/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.search;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Search
extends HttpServlet {
    public static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.search.Localization";
    public static final String SEARCH_FOR = "searchFor";
    public static final String SEARCH_STRING = "search_string";
    public static final String SEARCH_GLOBAL = "global";
    public static final String SEARCH_HOSTS = "hosts";
    public static final String SEARCH_SWITCHES = "switches";
    public static final String SEARCH_STORAGES = "storages";
    public static final String SEARCH_HBAS = "hbas";

    public void init() throws ServletException {
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        this.showInventory(httpServletRequest, httpServletResponse);
    }

    private void showInventory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        try {
            String string = httpServletRequest.getParameter(SEARCH_FOR);
            String string2 = httpServletRequest.getParameter(SEARCH_STRING);
            if (string2 == null) {
                string2 = "";
            }
            if (string != null) {
                if (string.equalsIgnoreCase(SEARCH_GLOBAL)) {
                    string = null;
                } else if (string.equalsIgnoreCase(SEARCH_HOSTS)) {
                    UtilsWeb.redirect(HTMLTags.modifyURLParameter(NSMPages.getPageURL(NSMPages.HOST_INVENTORY_PAGE), "find", string2), httpServletResponse);
                } else if (string.equalsIgnoreCase(SEARCH_HBAS)) {
                    UtilsWeb.redirect(HTMLTags.modifyURLParameter(NSMPages.getPageURL(NSMPages.HBA_INVENTORY_PAGE), "find", string2), httpServletResponse);
                } else if (string.equalsIgnoreCase(SEARCH_SWITCHES)) {
                    UtilsWeb.redirect(HTMLTags.modifyURLParameter(NSMPages.getPageURL(NSMPages.SWITCH_INVENTORY_PAGE), "find", string2), httpServletResponse);
                } else if (string.equalsIgnoreCase(SEARCH_STORAGES)) {
                    UtilsWeb.redirect(HTMLTags.modifyURLParameter(NSMPages.getPageURL(NSMPages.STORAGE_INVENTORY_PAGE), "find", string2), httpServletResponse);
                }
            }
            if (string == null) {
                UtilsWeb.noCacheHeader(httpServletResponse);
                Masthead.getMasthead(this.getServletContext()).printMasthead(httpServletRequest, httpServletResponse, NSMPages.SEARCH_PAGE);
                printWriter.print(HTMLTags.getBreadCrumbTag(httpServletRequest, NSMPages.SEARCH_PAGE));
                printWriter.print(HTMLTags.getContentStartTags(NSMPages.SEARCH_PAGE));
                HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "no_search_criteria"));
                printWriter.print(HTMLTags.getPendingMessagesTag(httpServletRequest));
                printWriter.print(HTMLTags.getContentEndTags());
                printWriter.flush();
            }
        }
        catch (Throwable throwable) {
            UtilsWeb.printThrowable(printWriter, throwable);
        }
    }

    public void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    public void destroy() {
    }
}

