/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.ports;

import com.sun.netstorage.mgmt.common.datamodel.Asset;
import com.sun.netstorage.mgmt.common.datamodel.AssetStorage;
import com.sun.netstorage.mgmt.common.datamodel.PersistenceException;
import com.sun.netstorage.mgmt.component.model.api.gui.AssetNxPort;
import com.sun.netstorage.mgmt.component.model.api.gui.AssetPort;
import com.sun.netstorage.mgmt.component.model.api.gui.SwitchAssetPort;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.ports.AttachedPortsConstants;
import com.sun.netstorage.mgmt.nsmui.util.Utils;

public class AttachedPortsCommand {
    private static final boolean debug = false;
    AssetStorage pm;
    private AssetPort[] ports;
    private String key;
    private String[] sortBy;
    private boolean[] sortOrder;
    private String find = null;
    private AssetPort asset;

    public AttachedPortsCommand(String string, boolean bl, String string2) {
        if (string == null) {
            this.sortBy = new String[0];
            this.sortOrder = new boolean[0];
        } else {
            this.sortBy = new String[]{string};
            this.sortOrder = new boolean[]{bl};
        }
        this.find = string2;
    }

    public void run() throws DataRetrievalException {
        this.ports = null;
        try {
            this.asset = Utils.getGuiPersistenceManager().getPortByKey(this.find);
            if (this.asset == null) {
                return;
            }
            this.ports = this.asset.getAttachedPorts(this.sortBy, this.sortOrder);
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException("Data retrieval error", persistenceException);
        }
    }

    public void getPortsByWWN() throws DataRetrievalException {
        this.ports = null;
        try {
            AssetPort assetPort = Utils.getGuiPersistenceManager().getPortByWWN(this.find);
            if (assetPort == null) {
                return;
            }
            this.ports = assetPort.getAttachedPorts(this.sortBy, this.sortOrder);
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException("Data retrieval error", persistenceException);
        }
    }

    public String getDeviceName() {
        return this.asset == null ? "" : this.asset.getWWN();
    }

    public String[][] getValues() throws PersistenceException {
        if (this.ports == null || this.ports.length == 0) {
            return null;
        }
        String[][] stringArray = new String[this.ports.length][AttachedPortsConstants.PORTS_COLUMN_NUMBER];
        int n = 0;
        while (n < this.ports.length) {
            AssetPort assetPort = this.ports[n];
            int n2 = 0;
            stringArray[n][n2++] = assetPort instanceof SwitchAssetPort ? ((SwitchAssetPort)assetPort).getPortType() : (assetPort instanceof AssetNxPort ? ((AssetNxPort)assetPort).getPortType() : assetPort.getType());
            stringArray[n][n2++] = assetPort.getWWN();
            Asset asset = assetPort.getDevice();
            stringArray[n][n2++] = asset == null ? null : asset.getType();
            stringArray[n][n2++] = asset == null ? null : Utils.createDuplet(asset.getKey(), asset.getName());
            ++n;
        }
        return stringArray;
    }

    private void _fillError(String string, String[] stringArray) {
        if (stringArray != null && stringArray.length > 1) {
            stringArray[1] = string;
        }
    }

    static void main(String[] stringArray) throws Exception {
        AttachedPortsCommand attachedPortsCommand = new AttachedPortsCommand(null, false, null);
        attachedPortsCommand.run();
        String[][] stringArray2 = attachedPortsCommand.getValues();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("->" + stringArray2[n][0]);
            ++n;
        }
    }
}

