/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.notification;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.notification.SNMPBean;
import com.sun.netstorage.mgmt.nsmui.notification.SNMPCommand;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SNMPMod
extends HttpServlet {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.notification.Localization";
    private SNMPCommand snmpCommand = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PrintWriter out;
    private String idValue;
    private SNMPBean sb;

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        this.out = httpServletResponse.getWriter();
        try {
            object = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, NSMPages.getPageURL(NSMPages.SNMP_MOD_PAGE));
            if (object == null || !((String)object).equalsIgnoreCase("Admin")) {
                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "not_authorized"));
                this.displayMasthead();
                return;
            }
        }
        catch (LoginException loginException) {
            return;
        }
        object = null;
        try {
            UtilsWeb.noCacheHeader(httpServletResponse);
            this.idValue = httpServletRequest.getParameter("id");
            if (this.idValue == null) {
                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "del_snmp_msg_no_id"));
                UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ADMIN_SNMP_PAGE), httpServletResponse);
            } else {
                this.snmpCommand = new SNMPCommand();
                this.snmpCommand.run();
                httpServletRequest.setAttribute("SNMPBeanId", (Object)this.sb);
                Hashtable hashtable = this.snmpCommand.getContract(this.idValue);
                if (hashtable == null) {
                    HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString(BUNDLE, "mod_snmp_msg_no_contract"));
                    this.displayMasthead();
                } else {
                    String string = Utils.mapSeverityToToken((String)hashtable.get("Criteria"));
                    String string2 = httpServletRequest.getParameter("submitcontrol");
                    if (string2 != null) {
                        if (string2.equals("savebutton")) {
                            this.setupInitialValues(string);
                            if (this.sb.getHostname().length() == 0) {
                                HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "mod_snmp_msg_empty_hostname"));
                            } else if (this.sb.getPort().length() == 0) {
                                HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "mod_snmp_msg_empty_port"));
                            } else if (this.checkPort(this.sb.getPort())) {
                                String string3 = this.snmpCommand.modContract(this.idValue, this.sb.getHostname(), this.sb.getPort(), this.sb.getLocale());
                                if (string3 == null) {
                                    UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ADMIN_SNMP_PAGE), httpServletResponse);
                                } else {
                                    HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", string3);
                                }
                            } else {
                                HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "mod_snmp_port_number"));
                            }
                            this.displayMasthead();
                            UtilsWeb.include(this.getServletContext(), "/jsp/snmpmod.jsp", httpServletRequest, httpServletResponse);
                        } else if (string2.equals("cancelbutton")) {
                            UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ADMIN_SNMP_PAGE), httpServletResponse);
                        }
                    } else {
                        this.setupInitialValues(hashtable);
                        this.displayMasthead();
                        UtilsWeb.include(this.getServletContext(), "/jsp/snmpmod.jsp", httpServletRequest, httpServletResponse);
                    }
                }
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            object = throwable instanceof NSMUIException ? (NSMUIException)throwable : new NSMUIException("", throwable);
        }
        if (object != null) {
            this.displayMasthead();
            this.out.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.SNMP_MOD_PAGE, (Throwable)object));
            this.out.flush();
        }
    }

    public void setupInitialValues(String string) {
        this.sb.setId(this.idValue);
        this.sb.setSeverity(string);
        this.sb.setHostname(this.request.getParameter("hostnametext"));
        this.sb.setPort(this.request.getParameter("porttext"));
        this.sb.setLocale(this.request.getParameter("localeselect").toLowerCase());
    }

    public void setupInitialValues(Hashtable hashtable) {
        this.sb.setId((String)hashtable.get("ID"));
        this.sb.setSeverity(Utils.mapSeverityToToken((String)hashtable.get("Criteria")));
        this.sb.setHostname((String)hashtable.get("Hostname"));
        this.sb.setLocale(((String)hashtable.get("Locale")).toLowerCase());
        this.sb.setPort((String)hashtable.get("Port"));
    }

    private void displayMasthead() throws ServletException, IOException {
        UtilsWeb.noCacheHeader(this.response);
        Masthead.getMasthead(this.getServletContext()).print("Administration", "Administration", "General", NSMPages.getPageHelp(NSMPages.SNMP_MOD_PAGE), this.request, this.response);
        this.out.println(HTMLTags.getBreadCrumbTag(this.request, NSMPages.SNMP_MOD_PAGE));
        this.out.println(HTMLTags.getPendingMessagesTag(this.request));
        this.out.flush();
    }

    private boolean checkPort(String string) {
        boolean bl = true;
        long l = 1L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (l <= 0L) {
            bl = false;
        }
        return bl;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.sb = new SNMPBean("snmpmodform");
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "This is the main SNMP Notification page.";
    }
}

