/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.notification;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.Configuration;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.service.notification.ContractSpecification;
import com.sun.netstorage.mgmt.service.notification.ContractSpecificationException;
import com.sun.netstorage.mgmt.service.notification.NotificationService;
import com.sun.netstorage.mgmt.service.notification.NotifierSpecification;
import com.sun.netstorage.mgmt.service.notification.SelectorSpecification;
import com.sun.netstorage.mgmt.service.notification.snmp.SnmpNotifierSpecification;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Enumeration;
import java.util.Hashtable;

public class SNMPCommand {
    private static int COLUMNS = 5;
    private static String BUNDLE = "com.sun.netstorage.mgmt.nsmui.notification.Localization";
    private NotificationService nService = null;
    private ContractSpecification[] contracts = null;
    private Hashtable snmpContracts = null;

    public SNMPCommand() throws NSMUIException {
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new SecurityManager());
            }
            String string = Configuration.getProperty("REGISTRY_HOST");
            Registry registry = null;
            try {
                registry = LocateRegistry.getRegistry(string, Integer.parseInt(Configuration.getProperty("NSM_RMI_REGISTRY_PORT")));
            }
            catch (NumberFormatException numberFormatException) {
                registry = LocateRegistry.getRegistry(string);
            }
            this.nService = (NotificationService)registry.lookup("notification");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
        }
    }

    public void run() throws NSMUIException {
        try {
            this.contracts = this.nService.getContracts();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
        }
        this.snmpContracts = this.mineContracts(this.contracts, "snmp");
    }

    public int count() {
        return this.snmpContracts.size();
    }

    public String[][] getContracts() {
        String[][] stringArray = new String[this.snmpContracts.size()][COLUMNS];
        if (this.contracts == null) {
            return new String[][]{new String[0]};
        }
        Enumeration enumeration = this.snmpContracts.elements();
        int n = 0;
        ContractSpecification contractSpecification = null;
        while (enumeration.hasMoreElements()) {
            contractSpecification = (ContractSpecification)enumeration.nextElement();
            SelectorSpecification selectorSpecification = contractSpecification.getSelectorSpecification();
            SnmpNotifierSpecification snmpNotifierSpecification = (SnmpNotifierSpecification)contractSpecification.getNotifierSpecification();
            stringArray[n][0] = String.valueOf(contractSpecification.getID());
            stringArray[n][1] = Utils.parseSeverity(selectorSpecification.getCriteria());
            stringArray[n][2] = snmpNotifierSpecification.getDestinationAddress().getHostName();
            stringArray[n][3] = String.valueOf(snmpNotifierSpecification.getDestinationPort());
            stringArray[n][4] = snmpNotifierSpecification.getLocale().toString();
            ++n;
        }
        return stringArray;
    }

    public Hashtable getContract(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ContractSpecification contractSpecification = (ContractSpecification)this.snmpContracts.get(string);
        if (contractSpecification != null) {
            SelectorSpecification selectorSpecification = contractSpecification.getSelectorSpecification();
            SnmpNotifierSpecification snmpNotifierSpecification = (SnmpNotifierSpecification)contractSpecification.getNotifierSpecification();
            hashtable.put("ID", String.valueOf(contractSpecification.getID()));
            hashtable.put("Criteria", Utils.parseSeverity(selectorSpecification.getCriteria()));
            hashtable.put("Hostname", snmpNotifierSpecification.getDestinationAddress().getHostName());
            hashtable.put("Port", String.valueOf(snmpNotifierSpecification.getDestinationPort()));
            hashtable.put("Locale", snmpNotifierSpecification.getLocale().toString());
        }
        if (contractSpecification == null) {
            return null;
        }
        return hashtable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long addContract(String string, String string2, String string3, String string4) throws NSMUIException, ContractSpecificationException {
        long l = 0L;
        if (string2.length() == 0) throw new NSMUIException(Localization.getString(BUNDLE, "add_snmp_msg_empty_address"));
        try {
            ContractSpecification contractSpecification = new ContractSpecification();
            SelectorSpecification selectorSpecification = contractSpecification.getSelectorSpecification();
            SnmpNotifierSpecification snmpNotifierSpecification = new SnmpNotifierSpecification();
            selectorSpecification.setCriteria(Utils.formatSeverityFromToken(string));
            snmpNotifierSpecification.setDestinationAddress(InetAddress.getByName(string2));
            snmpNotifierSpecification.setDestinationPort(Integer.parseInt(string3));
            snmpNotifierSpecification.setLocale(Utils.formatStringToLocale(string4));
            contractSpecification.setNotifierSpecification((NotifierSpecification)snmpNotifierSpecification);
            return this.nService.addContract(contractSpecification);
        }
        catch (ContractSpecificationException contractSpecificationException) {
            if (contractSpecificationException.getErrorNo() == 103) return l;
            throw contractSpecificationException;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
        }
    }

    public void deleteContract(String string) throws NSMUIException {
        boolean bl = false;
        if (!string.equals("0")) {
            try {
                bl = this.nService.removeContract(Long.parseLong(string), false);
            }
            catch (ContractSpecificationException contractSpecificationException) {
                if (contractSpecificationException.getErrorNo() != 301) {
                    // empty if block
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
            }
            if (!bl) {
                throw new NSMUIException(Localization.getString(BUNDLE, "del_snmp_msg_failed"));
            }
        } else {
            throw new NSMUIException(Localization.getString(BUNDLE, "mod_snmp_msg_empty_address"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String modContract(String string, String string2, String string3, String string4) throws NSMUIException, ContractSpecificationException {
        String string5 = null;
        if (string.equals("0")) return Localization.getString(BUNDLE, "mod_snmp_msg_empty_address");
        ContractSpecification contractSpecification = (ContractSpecification)this.snmpContracts.get(string);
        if (contractSpecification == null) return Localization.getString(BUNDLE, "mod_snmp_msg_invalid_address");
        try {
            SnmpNotifierSpecification snmpNotifierSpecification = (SnmpNotifierSpecification)contractSpecification.getNotifierSpecification();
            if (contractSpecification == null) return string5;
            snmpNotifierSpecification.setDestinationAddress(InetAddress.getByName(string2));
            snmpNotifierSpecification.setDestinationPort(Integer.parseInt(string3));
            snmpNotifierSpecification.setLocale(Utils.formatStringToLocale(string4));
            this.nService.modifyContract(contractSpecification);
            return string5;
        }
        catch (ContractSpecificationException contractSpecificationException) {
            if (contractSpecificationException.getErrorNo() == 103) return string5;
            throw contractSpecificationException;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "mod_snmp_contract_message"), throwable);
        }
    }

    public void pause(boolean bl) throws NSMUIException {
        try {
            if (bl) {
                this.nService.pauseContractByNotifierType("snmp");
            } else {
                this.nService.resumeContractByNotifierType("snmp");
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
        }
    }

    public boolean isPaused() throws NSMUIException {
        boolean bl = false;
        try {
            bl = this.nService.isNotifierTypePaused("snmp");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
        }
        return bl;
    }

    private Hashtable mineContracts(ContractSpecification[] contractSpecificationArray, String string) {
        Hashtable<String, ContractSpecification> hashtable = new Hashtable<String, ContractSpecification>();
        int n = 0;
        while (n < contractSpecificationArray.length) {
            ContractSpecification contractSpecification = contractSpecificationArray[n];
            if (contractSpecification.getNotifierSpecification().getNotifierSpecificationType().equals(string)) {
                String string2 = String.valueOf(contractSpecification.getID());
                hashtable.put(string2, contractSpecification);
            }
            ++n;
        }
        return hashtable;
    }

    static void main(String[] stringArray) throws Exception {
        SNMPCommand sNMPCommand = new SNMPCommand();
        sNMPCommand.run();
        String[][] stringArray2 = sNMPCommand.getContracts();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray2.length) {
            int n2 = 0;
            while (n2 < stringArray2[0].length) {
                stringBuffer.append(stringArray2[n][n2] + "        ");
                ++n2;
            }
            System.out.println(stringBuffer);
            ++n;
        }
        Hashtable hashtable = sNMPCommand.getContract("3");
        System.out.println("----> Contract for id=3:\n    " + hashtable.get("ID") + "    " + hashtable.get("Criteria") + "    " + hashtable.get("Trap") + "    " + hashtable.get("Hostname") + "    " + hashtable.get("Port") + "    " + hashtable.get("Locale"));
    }
}

