/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.notification;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.notification.SNMPBean;
import com.sun.netstorage.mgmt.nsmui.notification.SNMPCommand;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SNMPAdd
extends HttpServlet {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.notification.Localization";
    private SNMPCommand snmpCommand = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PrintWriter out;
    private SNMPBean sb;

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        this.out = httpServletResponse.getWriter();
        try {
            object = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, NSMPages.getPageURL(NSMPages.SNMP_ADD_PAGE));
            if (object == null || !((String)object).equalsIgnoreCase("Admin")) {
                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "not_authorized"));
                this.displayMasthead();
                return;
            }
        }
        catch (LoginException loginException) {
            return;
        }
        object = null;
        try {
            UtilsWeb.noCacheHeader(httpServletResponse);
            this.snmpCommand = new SNMPCommand();
            this.snmpCommand.run();
            httpServletRequest.setAttribute("SNMPBeanId", (Object)this.sb);
            String string = httpServletRequest.getParameter("submitcontrol");
            if (string != null) {
                if (string.equals("savebutton")) {
                    this.setupInitialValues(false);
                    if (this.sb.getHostname().length() == 0) {
                        HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "add_snmp_msg_empty_hostname"));
                    } else if (this.sb.getPort().length() == 0) {
                        HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "add_snmp_msg_empty_port"));
                    } else if (this.checkPort(this.sb.getPort())) {
                        this.snmpCommand.addContract(this.sb.getSeverity(), this.sb.getHostname(), this.sb.getPort(), this.sb.getLocale());
                        HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString(BUNDLE, "add_snmp_msg_contract_added"));
                    } else {
                        HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "add_snmp_port_number"));
                    }
                    this.displayMasthead();
                    UtilsWeb.include(this.getServletContext(), "/jsp/snmpadd.jsp", httpServletRequest, httpServletResponse);
                } else if (string.equals("cancelbutton")) {
                    UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ADMIN_SNMP_PAGE), httpServletResponse);
                }
            } else {
                this.setupInitialValues(true);
                this.displayMasthead();
                UtilsWeb.include(this.getServletContext(), "/jsp/snmpadd.jsp", httpServletRequest, httpServletResponse);
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            object = throwable instanceof NSMUIException ? (NSMUIException)throwable : new NSMUIException("", throwable);
        }
        if (object != null) {
            this.displayMasthead();
            this.out.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.SNMP_ADD_PAGE, (Throwable)object));
            this.out.flush();
        }
    }

    public void setupInitialValues(boolean bl) {
        if (bl) {
            this.sb.setSeverity("down");
            this.sb.setHostname("");
            this.sb.setLocale(Locale.getDefault().toString().toLowerCase());
            this.sb.setPort("162");
        } else {
            this.sb.setSeverity(this.request.getParameter("severityselect"));
            this.sb.setHostname(this.request.getParameter("hostnametext"));
            this.sb.setLocale(this.request.getParameter("localeselect"));
            this.sb.setPort(this.request.getParameter("porttext"));
        }
    }

    private void displayMasthead() throws ServletException, IOException {
        UtilsWeb.noCacheHeader(this.response);
        Masthead.getMasthead(this.getServletContext()).print("Administration", "Administration", "General", NSMPages.getPageHelp(NSMPages.SNMP_ADD_PAGE), this.request, this.response);
        this.out.println(HTMLTags.getBreadCrumbTag(this.request, NSMPages.SNMP_ADD_PAGE));
        this.out.println(HTMLTags.getPendingMessagesTag(this.request));
        this.out.flush();
    }

    private boolean checkPort(String string) {
        boolean bl = true;
        long l = 1L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (l <= 0L) {
            bl = false;
        }
        return bl;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.sb = new SNMPBean("snmpaddform");
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "This is the main SNMP Notification page.";
    }
}

