/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.notification;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.Configuration;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.service.notification.ContractSpecification;
import com.sun.netstorage.mgmt.service.notification.ContractSpecificationException;
import com.sun.netstorage.mgmt.service.notification.NotificationService;
import com.sun.netstorage.mgmt.service.notification.NotifierSpecification;
import com.sun.netstorage.mgmt.service.notification.SelectorSpecification;
import com.sun.netstorage.mgmt.service.notification.email.EmailNotifierSpecification;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class EmailCommand {
    private static int COLUMNS = 6;
    private static String BUNDLE = "com.sun.netstorage.mgmt.nsmui.notification.Localization";
    private NotificationService nService = null;
    private ContractSpecification[] contracts = null;
    private Hashtable emailContracts = null;

    public EmailCommand() throws NSMUIException {
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new SecurityManager());
            }
            String string = Configuration.getProperty("REGISTRY_HOST");
            Registry registry = null;
            try {
                registry = LocateRegistry.getRegistry(string, Integer.parseInt(Configuration.getProperty("NSM_RMI_REGISTRY_PORT")));
            }
            catch (NumberFormatException numberFormatException) {
                registry = LocateRegistry.getRegistry(string);
            }
            this.nService = (NotificationService)registry.lookup("notification");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
        }
    }

    public void run() throws NSMUIException {
        try {
            this.contracts = this.nService.getContracts();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
        }
        this.emailContracts = this.mineContracts(this.contracts, "email");
        Enumeration enumeration = this.emailContracts.elements();
    }

    public int count() {
        return this.emailContracts.size();
    }

    public String[][] getContracts() {
        String[][] stringArray = new String[this.emailContracts.size()][COLUMNS];
        if (this.contracts == null) {
            return new String[][]{new String[0]};
        }
        Enumeration enumeration = this.emailContracts.elements();
        int n = 0;
        ContractSpecification contractSpecification = null;
        while (enumeration.hasMoreElements()) {
            contractSpecification = (ContractSpecification)enumeration.nextElement();
            SelectorSpecification selectorSpecification = contractSpecification.getSelectorSpecification();
            EmailNotifierSpecification emailNotifierSpecification = (EmailNotifierSpecification)contractSpecification.getNotifierSpecification();
            stringArray[n][0] = String.valueOf(contractSpecification.getID());
            stringArray[n][1] = Utils.parseSeverity(selectorSpecification.getCriteria());
            stringArray[n][2] = emailNotifierSpecification.getIsPager();
            stringArray[n][3] = this.stringArrayToOneString(emailNotifierSpecification.getTo());
            stringArray[n][4] = String.valueOf(emailNotifierSpecification.getNotificationInterval());
            stringArray[n][5] = emailNotifierSpecification.getLocale().toString();
            ++n;
        }
        return stringArray;
    }

    public Hashtable getContract(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ContractSpecification contractSpecification = (ContractSpecification)this.emailContracts.get(string);
        if (contractSpecification != null) {
            SelectorSpecification selectorSpecification = contractSpecification.getSelectorSpecification();
            EmailNotifierSpecification emailNotifierSpecification = (EmailNotifierSpecification)contractSpecification.getNotifierSpecification();
            hashtable.put("ID", String.valueOf(contractSpecification.getID()));
            hashtable.put("Criteria", Utils.parseSeverity(selectorSpecification.getCriteria()));
            hashtable.put("IsPager", emailNotifierSpecification.getIsPager());
            hashtable.put("To", this.stringArrayToOneString(emailNotifierSpecification.getTo()));
            hashtable.put("NotificationInterval", String.valueOf(emailNotifierSpecification.getNotificationInterval()));
            hashtable.put("Locale", emailNotifierSpecification.getLocale().toString());
        }
        if (contractSpecification == null) {
            return null;
        }
        return hashtable;
    }

    public String getSMTPHost() throws NSMUIException {
        String string = "";
        Properties properties = null;
        try {
            properties = this.nService.getNotifierProperties("email");
            string = properties.getProperty("MailHost");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
        }
        return string;
    }

    public String setSMTPHost(String string) throws NSMUIException {
        String string2 = null;
        String string3 = "";
        Properties properties = null;
        try {
            properties = this.nService.getNotifierProperties("email");
            properties.put("MailHost", string);
            this.nService.setNotifierProperties("email", properties);
        }
        catch (RemoteException remoteException) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), remoteException);
        }
        catch (Exception exception) {
            string2 = Localization.getString(BUNDLE, "invalid_smtp_server", string);
        }
        return string2;
    }

    public void sendTestEmail(String string) throws NSMUIException {
        try {
            EmailNotifierSpecification emailNotifierSpecification = new EmailNotifierSpecification();
            emailNotifierSpecification.setTo(this.stringToStringArray(string));
            emailNotifierSpecification.setFrom(Localization.getString(BUNDLE, "email_from"));
            this.nService.testNotifier((NotifierSpecification)emailNotifierSpecification);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long addContract(String string, String string2, String string3, String string4, String string5, String string6) throws NSMUIException, ContractSpecificationException {
        long l = 0L;
        if (string2.length() == 0) throw new NSMUIException(Localization.getString(BUNDLE, "add_email_msg_empty_address"));
        try {
            ContractSpecification contractSpecification = new ContractSpecification();
            SelectorSpecification selectorSpecification = contractSpecification.getSelectorSpecification();
            EmailNotifierSpecification emailNotifierSpecification = new EmailNotifierSpecification();
            selectorSpecification.setCriteria(Utils.formatSeverityFromToken(string));
            emailNotifierSpecification.setTo(this.stringToStringArray(string2));
            emailNotifierSpecification.setSubject(string3);
            emailNotifierSpecification.setFrom(Localization.getString(BUNDLE, "email_from"));
            emailNotifierSpecification.setIsPager(string4.equals("pager") ? "yes" : "no");
            emailNotifierSpecification.setNotificationInterval(Long.parseLong(string5));
            emailNotifierSpecification.setLocale(Utils.formatStringToLocale(string6));
            contractSpecification.setNotifierSpecification((NotifierSpecification)emailNotifierSpecification);
            return this.nService.addContract(contractSpecification);
        }
        catch (ContractSpecificationException contractSpecificationException) {
            if (contractSpecificationException.getErrorNo() == 103) return l;
            throw contractSpecificationException;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
        }
    }

    public void deleteContract(String string) throws NSMUIException {
        boolean bl = false;
        if (!string.equals("0")) {
            try {
                bl = this.nService.removeContract(Long.parseLong(string), false);
            }
            catch (ContractSpecificationException contractSpecificationException) {
                if (contractSpecificationException.getErrorNo() != 301) {
                    // empty if block
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
            }
            if (!bl) {
                throw new NSMUIException(Localization.getString(BUNDLE, "del_email_msg_failed"));
            }
        } else {
            throw new NSMUIException(Localization.getString(BUNDLE, "mod_email_msg_empty_address"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String modContract(String string, String string2, String string3, String string4, String string5) throws NSMUIException, ContractSpecificationException {
        String string6 = null;
        if (string.equals("0")) return Localization.getString(BUNDLE, "mod_email_msg_empty_address");
        ContractSpecification contractSpecification = (ContractSpecification)this.emailContracts.get(string);
        if (contractSpecification == null) return Localization.getString(BUNDLE, "mod_email_msg_invalid_address");
        try {
            EmailNotifierSpecification emailNotifierSpecification = (EmailNotifierSpecification)contractSpecification.getNotifierSpecification();
            if (contractSpecification == null) return string6;
            emailNotifierSpecification.setTo(this.stringToStringArray(string2));
            emailNotifierSpecification.setFrom(Localization.getString(BUNDLE, "email_from"));
            emailNotifierSpecification.setIsPager(string3.equals("pager") ? "yes" : "no");
            emailNotifierSpecification.setNotificationInterval(Long.parseLong(string4));
            emailNotifierSpecification.setLocale(Utils.formatStringToLocale(string5));
            this.nService.modifyContract(contractSpecification);
            return string6;
        }
        catch (ContractSpecificationException contractSpecificationException) {
            if (contractSpecificationException.getErrorNo() == 103) return string6;
            throw contractSpecificationException;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "mod_email_contract_message"), throwable);
        }
    }

    public void pause(boolean bl) throws NSMUIException {
        try {
            if (bl) {
                this.nService.pauseContractByNotifierType("email");
            } else {
                this.nService.resumeContractByNotifierType("email");
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
        }
    }

    public boolean isPaused() throws NSMUIException {
        boolean bl = false;
        try {
            bl = this.nService.isNotifierTypePaused("email");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_service"), throwable);
        }
        return bl;
    }

    private String stringArrayToOneString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n == 0) {
                stringBuffer.append(stringArray[n]);
            } else {
                stringBuffer.append(", " + stringArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private String[] stringToStringArray(String string) {
        String[] stringArray = new String[]{""};
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        if (stringTokenizer.countTokens() != 0) {
            stringArray = new String[stringTokenizer.countTokens()];
        }
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n] = (String)stringTokenizer.nextElement();
            ++n;
        }
        return stringArray;
    }

    private Hashtable mineContracts(ContractSpecification[] contractSpecificationArray, String string) {
        Hashtable<String, ContractSpecification> hashtable = new Hashtable<String, ContractSpecification>();
        int n = 0;
        while (n < contractSpecificationArray.length) {
            ContractSpecification contractSpecification = contractSpecificationArray[n];
            if (contractSpecification.getNotifierSpecification().getNotifierSpecificationType().equals(string)) {
                String string2 = String.valueOf(contractSpecification.getID());
                hashtable.put(string2, contractSpecification);
            }
            ++n;
        }
        return hashtable;
    }

    static void main(String[] stringArray) throws Exception {
        EmailCommand emailCommand = new EmailCommand();
        emailCommand.run();
        String[][] stringArray2 = emailCommand.getContracts();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray2.length) {
            int n2 = 0;
            while (n2 < stringArray2[0].length) {
                stringBuffer.append(stringArray2[n][n2] + "        ");
                ++n2;
            }
            System.out.println(stringBuffer);
            ++n;
        }
        Hashtable hashtable = emailCommand.getContract("3");
        System.out.println("----> Contract for id=3:\n    " + hashtable.get("ID") + "    " + hashtable.get("Criteria") + "    " + hashtable.get("To") + "    " + hashtable.get("IsPager") + "    " + hashtable.get("NotificationInterval") + "    " + hashtable.get("Locale"));
    }
}

