/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.notification;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.notification.EmailBean;
import com.sun.netstorage.mgmt.nsmui.notification.EmailCommand;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EmailAdd
extends HttpServlet {
    private static final String EMAIL_ADD_FORM_NAME = "emailaddform";
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.notification.Localization";
    private static final String SEVERITY_MENU_NAME = "severityselect";
    private static final String MEDIUM_MENU_NAME = "mediumselect";
    private static final String PERIOD_MENU_NAME = "timeselect";
    private static final String LOCALE_MENU_NAME = "localeselect";
    private static final String ADDRESS_TEXT_NAME = "addressText";
    private static final String TIME_TEXT_NAME = "timeText";
    private static final String SEND_BUTTON_NAME = "testemailbutton";
    private static final String SAVE_BUTTON_NAME = "savebutton";
    private static final String SEND_BUTTON_LABEL = "send_label";
    private static final String SAVE_BUTTON_LABEL = "save_label";
    private static final int NO_MESSAGE = 0;
    private static final int INFO_MESSAGE = 1;
    private static final int WARNING_MESSAGE = 2;
    private static final int ERROR_MESSAGE = 3;
    private EmailCommand emailCommand = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PrintWriter out;
    private EmailBean eb;

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        block22: {
            this.request = httpServletRequest;
            this.response = httpServletResponse;
            UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
            this.out = httpServletResponse.getWriter();
            try {
                object = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, NSMPages.getPageURL(NSMPages.EMAIL_ADD_PAGE));
                if (object == null || !((String)object).equalsIgnoreCase("Admin")) {
                    HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "not_authorized"));
                    this.displayMasthead();
                    return;
                }
            }
            catch (LoginException loginException) {
                return;
            }
            object = null;
            try {
                UtilsWeb.noCacheHeader(httpServletResponse);
                this.emailCommand = new EmailCommand();
                this.emailCommand.run();
                httpServletRequest.setAttribute("EmailAddId", (Object)this.eb);
                String string = httpServletRequest.getParameter("submitcontrol");
                if (string != null) {
                    if (string.equals(SAVE_BUTTON_NAME)) {
                        this.setupInitialValues(false);
                        if (this.eb.getAddress().length() == 0) {
                            HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "add_email_msg_empty_address"));
                        } else {
                            String string2 = this.eb.getTime();
                            String string3 = this.eb.getPeriod();
                            if (string2 != null && string3 != null) {
                                if (string2.equals("")) {
                                    string2 = "0";
                                }
                                boolean bl = true;
                                long l = 0L;
                                try {
                                    l = Long.parseLong(Utils.getMinutesValue(string2, string3));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    bl = false;
                                    HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "add_email_min_time_number"));
                                }
                                if (l < 0L) {
                                    bl = false;
                                    HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "add_email_min_time_number"));
                                }
                                if (bl) {
                                    String string4 = Localization.getString(BUNDLE, "subject_line", Utils.formatStringToLocale(this.eb.getLocale())) + Localization.getString(BUNDLE, "severity_level_" + this.eb.getSeverity(), Utils.formatStringToLocale(this.eb.getLocale()));
                                    this.emailCommand.addContract(this.eb.getSeverity(), this.eb.getAddress(), string4, this.eb.getMedium(), Utils.getMinutesValue(this.eb.getTime(), this.eb.getPeriod()), this.eb.getLocale());
                                    HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString(BUNDLE, "add_email_msg_address_added"));
                                }
                            }
                        }
                        this.displayMasthead();
                        UtilsWeb.include(this.getServletContext(), "/jsp/emailadd.jsp", httpServletRequest, httpServletResponse);
                        break block22;
                    }
                    if (string.equals("cancelbutton")) {
                        UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ADMIN_EMAIL_PAGE), httpServletResponse);
                    } else if (string.equals(SEND_BUTTON_NAME)) {
                        this.setupInitialValues(false);
                        if (this.eb.getAddress().length() == 0) {
                            HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "add_email_msg_empty_address"));
                        } else {
                            this.emailCommand.sendTestEmail(this.eb.getAddress());
                            HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString(BUNDLE, "add_email_msg_test_sent"));
                        }
                        this.displayMasthead();
                        UtilsWeb.include(this.getServletContext(), "/jsp/emailadd.jsp", httpServletRequest, httpServletResponse);
                    }
                    break block22;
                }
                this.setupInitialValues(true);
                this.displayMasthead();
                UtilsWeb.include(this.getServletContext(), "/jsp/emailadd.jsp", httpServletRequest, httpServletResponse);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                object = throwable instanceof NSMUIException ? (NSMUIException)throwable : new NSMUIException("", throwable);
            }
        }
        if (object != null) {
            this.displayMasthead();
            this.out.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.EMAIL_ADD_PAGE, (Throwable)object));
            this.out.flush();
        }
    }

    public void setupInitialValues(boolean bl) {
        if (bl) {
            this.eb.setSeverity("down");
            this.eb.setMedium("email");
            this.eb.setPeriod("minutes");
            this.eb.setLocale(Locale.getDefault().toString().toLowerCase());
            this.eb.setAddress("");
            this.eb.setTime("0");
        } else {
            this.eb.setSeverity(this.request.getParameter(SEVERITY_MENU_NAME));
            this.eb.setMedium(this.request.getParameter(MEDIUM_MENU_NAME));
            this.eb.setPeriod(this.request.getParameter(PERIOD_MENU_NAME));
            this.eb.setLocale(this.request.getParameter(LOCALE_MENU_NAME));
            this.eb.setAddress(this.request.getParameter(ADDRESS_TEXT_NAME));
            this.eb.setTime(this.request.getParameter(TIME_TEXT_NAME).equals("") ? "0" : this.request.getParameter(TIME_TEXT_NAME));
        }
    }

    private void displayMasthead() throws ServletException, IOException {
        UtilsWeb.noCacheHeader(this.response);
        Masthead.getMasthead(this.getServletContext()).print("Administration", "Administration", "General", NSMPages.getPageHelp(NSMPages.EMAIL_ADD_PAGE), this.request, this.response);
        this.out.println(HTMLTags.getBreadCrumbTag(this.request, NSMPages.EMAIL_ADD_PAGE));
        this.out.println(HTMLTags.getPendingMessagesTag(this.request));
        this.out.flush();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.eb = new EmailBean(EMAIL_ADD_FORM_NAME);
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "This is the main Email Notification page.";
    }
}

