/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.notification;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.notification.EmailCommand;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.SeverityColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Email
extends HttpServlet {
    private static final String PAGE_URL = "/nsm/email";
    private static final String EMAIL_FORM_NAME = "emailform";
    private EmailCommand emailCommand = null;
    private static final int DEFAULT_SORT_COL = -2;
    private static final TableColumn[] COLUMNS = new TableColumn[6];
    private static final int ID_COLUMN = 0;
    private static final int LEVEL_COLUMN = 1;
    private static final int PAGER_COLUMN = 2;
    private static final int ADDRESS_COLUMN = 3;
    private static final int TIME_COLUMN = 4;
    private static final int LOCALE_COLUMN = 5;
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.notification.Localization";
    private static final String SMTP_HEADER_LABEL = "smtp_header_label";
    private static final String SMTP_FIELD_LABEL = "smtp_iphost_label";
    private static final String SMTP_FIELD_NAME = "smtphost";
    private static final String LEVEL_HEADER_LABEL = "alarm_level_header_label";
    private static final String TABLE_HEADER_LABEL = "email_table_title";
    private static final String UPDATE_BUTTON_NAME = "updatebutton";
    private static final String UPDATE_BUTTON_LABEL = "update_label";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PrintWriter out;
    private String[] buttonItems = new String[]{"email_action_menu_item1", "email_action_menu_item2", "email_action_menu_item3"};
    private boolean[] buttonsOff = new boolean[]{true, false, false};
    private boolean[] buttonsOn = new boolean[]{true, true, true};
    private String smtphost = "";
    private String tableTitle;
    private String theTable;

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        this.out = httpServletResponse.getWriter();
        try {
            object = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, NSMPages.getPageURL(NSMPages.ADMIN_EMAIL_PAGE));
            if (object == null || !((String)object).equalsIgnoreCase("Admin")) {
                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "not_authorized"));
                this.displayMasthead();
                return;
            }
        }
        catch (LoginException loginException) {
            return;
        }
        object = null;
        boolean bl = false;
        try {
            UtilsWeb.noCacheHeader(httpServletResponse);
            this.emailCommand = new EmailCommand();
            this.emailCommand.run();
            httpServletRequest.setAttribute("EmailId", (Object)this);
            String string = httpServletRequest.getParameter("submitcontrol");
            if (string != null) {
                if (string.equals(UPDATE_BUTTON_NAME)) {
                    String string2 = null;
                    String string3 = null;
                    string2 = httpServletRequest.getParameter(SMTP_FIELD_NAME);
                    if (string2 != null) {
                        if (!string2.equals("")) {
                            string3 = this.emailCommand.setSMTPHost(string2);
                            if (string3 != null) {
                                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", string3);
                            }
                        } else {
                            HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "smtp_no_host"));
                        }
                    }
                } else {
                    String string4 = httpServletRequest.getParameter("id");
                    this.smtphost = "";
                    this.smtphost = this.emailCommand.getSMTPHost();
                    if (!this.smtphost.equals("")) {
                        if (string.equals("email_action_menu_item1")) {
                            UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.EMAIL_ADD_PAGE), httpServletResponse);
                            bl = true;
                        } else if (string.equals("email_action_menu_item2")) {
                            if (string4 != null) {
                                UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.EMAIL_DEL_PAGE) + "?id=" + httpServletRequest.getParameter("id"), httpServletResponse);
                                bl = true;
                            } else {
                                HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString(BUNDLE, "email_msg_no_id"));
                            }
                        } else if (string.equals("email_action_menu_item3")) {
                            if (string4 != null) {
                                UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.EMAIL_MOD_PAGE) + "?id=" + httpServletRequest.getParameter("id"), httpServletResponse);
                                bl = true;
                            } else {
                                HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString(BUNDLE, "email_msg_no_id"));
                            }
                        }
                    } else {
                        HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "smtp_no_host"));
                    }
                }
            }
            this.smtphost = "";
            this.smtphost = this.emailCommand.getSMTPHost();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            object = throwable instanceof NSMUIException ? (NSMUIException)throwable : new NSMUIException("", throwable);
        }
        if (!bl) {
            this.displayMasthead();
            if (object != null) {
                this.out.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.ADMIN_EMAIL_PAGE, (Throwable)object));
                this.out.flush();
            } else {
                this.buildTable();
                UtilsWeb.include(this.getServletContext(), "/jsp/email.jsp", httpServletRequest, httpServletResponse);
            }
        }
    }

    private void displayMasthead() throws ServletException, IOException {
        UtilsWeb.noCacheHeader(this.response);
        Masthead.getMasthead(this.getServletContext()).print("Administration", "Administration", "General", NSMPages.getPageHelp(NSMPages.ADMIN_EMAIL_PAGE), this.request, this.response);
        this.out.println(HTMLTags.getBreadCrumbTag(this.request, NSMPages.ADMIN_EMAIL_PAGE));
        this.out.println(HTMLTags.getPendingMessagesTag(this.request));
        this.out.flush();
    }

    public void buildTable() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = this.emailCommand.count();
        HTMLTags.TableInfo tableInfo = HTMLTags.getTableInfo(this.request, -2, n);
        int n2 = tableInfo.sortColumn;
        int n3 = tableInfo.firstRow;
        int n4 = tableInfo.pageSize;
        String[][] stringArray = this.emailCommand.getContracts();
        int n5 = 0;
        while (n5 < this.emailCommand.count()) {
            stringArray[n5][5] = Localization.getString(BUNDLE, stringArray[n5][5].toLowerCase());
            ++n5;
        }
        int n6 = Math.abs(tableInfo.sortColumn) - 1;
        if (n6 == 1) {
            Arrays.sort(stringArray, new SeverityColumnComparator(n2));
        } else {
            Arrays.sort(stringArray, new SmartColumnComparator(n2));
        }
        int n7 = Math.min(n4, n - n3);
        String[][] stringArray2 = new String[n7][];
        System.arraycopy(stringArray, n3, stringArray2, 0, n7);
        int n8 = 0;
        while (n8 < n7) {
            stringArray2[n8][1] = this.getLevel(stringArray2[n8][1]);
            ++n8;
        }
        int n9 = 0;
        while (n9 < n7) {
            stringArray2[n9][2] = this.getPager(stringArray2[n9][2]);
            ++n9;
        }
        int n10 = 0;
        while (n10 < n7) {
            stringArray2[n10][4] = this.getPeriod(stringArray2[n10][4]);
            ++n10;
        }
        int n11 = 0;
        while (n11 < n7) {
            stringArray2[n11][0] = "<input type=radio name=id value=" + stringArray2[n11][0] + ">";
            ++n11;
        }
        this.tableTitle = n <= n4 ? HTMLTags.getTableTitleTag(Localization.getString(BUNDLE, TABLE_HEADER_LABEL)) : HTMLTags.getTableTitleTag(Localization.getString(BUNDLE, TABLE_HEADER_LABEL), n3, n, n4);
        if (n == 0) {
            stringBuffer2.append(HTMLTags.getActionButtonsTag(BUNDLE, "actionMenuTitle", this.buttonItems, this.buttonsOff));
        } else {
            stringBuffer2.append(HTMLTags.getActionButtonsTag(BUNDLE, "actionMenuTitle", this.buttonItems, this.buttonsOn));
        }
        stringBuffer2.append(HTMLTags.getTableTag(PAGE_URL, COLUMNS, stringArray2, n2, n3, n, n4));
        this.theTable = stringBuffer2.toString();
    }

    public String getSMTPServerField() {
        return HTMLTags.getInputFieldTag(SMTP_FIELD_NAME, this.smtphost, 24, 24);
    }

    public String getUpdateButton() {
        return HTMLTags.getSubmitMiniButtonTag(UPDATE_BUTTON_NAME, Localization.getString(BUNDLE, UPDATE_BUTTON_LABEL));
    }

    public String getSMTPHeaderLabel() {
        return HTMLTags.getCustomTag(BUNDLE, SMTP_HEADER_LABEL);
    }

    public String getIPHostLabel() {
        return HTMLTags.getCustomTag(BUNDLE, SMTP_FIELD_LABEL);
    }

    public String getAlarmLevelLabel() {
        return HTMLTags.getCustomTag(BUNDLE, LEVEL_HEADER_LABEL);
    }

    public String getEmailTableText() {
        return HTMLTags.getCustomTag(BUNDLE, TABLE_HEADER_LABEL);
    }

    public String getEmailTableTitle() {
        return this.tableTitle;
    }

    public String getEmailTable() {
        return this.theTable;
    }

    private String getPeriod(String string) {
        String string2 = " " + Localization.getString(BUNDLE, "minutes");
        long l = Long.parseLong(string);
        long l2 = 0L;
        if (l != 0L) {
            if (l % 1440L == 0L) {
                l2 = l / 1440L;
                string2 = " " + Localization.getString(BUNDLE, "days");
            } else if (l % 60L == 0L) {
                l2 = l / 60L;
                string2 = " " + Localization.getString(BUNDLE, "hours");
            } else {
                l2 = l;
                string2 = " " + Localization.getString(BUNDLE, "minutes");
            }
        }
        return String.valueOf(l2) + string2;
    }

    private String getLevel(String string) {
        String string2 = Utils.mapSeverityToToken(string);
        return "<IMG src=\"/nsm/images/icons/" + Localization.getString(BUNDLE, "level_icon_14_" + string2) + "\" width=\"14\" height=\"14\" border=\"0\" alt=\"" + Localization.getString(BUNDLE, "level_icon_text_" + string2) + "\"> " + Localization.getString(BUNDLE, string2);
    }

    private String getPager(String string) {
        return string.equals("yes") ? Localization.getString(BUNDLE, "pager") : Localization.getString(BUNDLE, "email");
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (COLUMNS[0] == null) {
            Email.COLUMNS[0] = new TableColumn("    ", false, "\"left\"");
            Email.COLUMNS[1] = new TableColumn(Localization.getString(BUNDLE, "email_table_title_level"), true, "\"left\"");
            Email.COLUMNS[2] = new TableColumn(Localization.getString(BUNDLE, "email_table_title_medium"), true, "\"left\"");
            Email.COLUMNS[3] = new TableColumn(Localization.getString(BUNDLE, "email_table_title_address"), true, "\"left\"");
            Email.COLUMNS[4] = new TableColumn(Localization.getString(BUNDLE, "email_table_title_time"), true, "\"right\"");
            Email.COLUMNS[5] = new TableColumn(Localization.getString(BUNDLE, "email_table_title_locale"), true, "\"left\"");
        }
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "This is the main Email Notification page.";
    }
}

