/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.host;

import com.sun.netstorage.mgmt.common.datamodel.Asset;
import com.sun.netstorage.mgmt.common.datamodel.PersistenceException;
import com.sun.netstorage.mgmt.component.model.api.gui.HBAAsset;
import com.sun.netstorage.mgmt.component.model.api.gui.HostAsset;
import com.sun.netstorage.mgmt.nsmui.common.DataInterpretationException;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.host.HostConstants;
import com.sun.netstorage.mgmt.nsmui.util.Utils;

public class HostDetailCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.host";
    private HostAsset host;
    private final String deviceId;
    private String newAnnot;
    boolean remove = false;

    public HostDetailCommand(String string, String string2) throws NSMUIException {
        if (string == null || string.equals("")) {
            throw new NSMUIException("deviceid==null", null);
        }
        this.deviceId = string;
        this.newAnnot = string2;
    }

    public void requestRemove() {
        this.remove = true;
    }

    public void run() throws DataRetrievalException, DataInterpretationException {
        this.host = null;
        try {
            Asset asset = Utils.getAssetStorage().getAsset(this.deviceId);
            if (asset != null) {
                this.host = (HostAsset)Utils.getAssetStorage().getAsset(this.deviceId);
                if (this.remove) {
                    this.host.delete();
                    this.host = null;
                } else if (this.newAnnot != null) {
                    this.host.setAnnotation(this.newAnnot);
                }
            }
        }
        catch (PersistenceException persistenceException) {
            throw new DataRetrievalException("Data retrieval error", persistenceException);
        }
        catch (Exception exception) {
            throw new DataInterpretationException("Error with asset's model object", exception);
        }
    }

    public boolean isStale() {
        return this.host == null ? false : this.host.isStale();
    }

    public String getDeviceKey() {
        return this.host == null ? null : this.host.getKey();
    }

    public String getDeviceName() {
        return this.host == null ? null : this.host.getName();
    }

    public String[] getValues() throws PersistenceException {
        String[] stringArray = new String[HostConstants.DETAIL_ROW_NUMBER];
        if (this.host == null) {
            return null;
        }
        stringArray[0] = Utils.getVendorModel(this.host.getVendor(), this.host.getModel());
        stringArray[1] = this.host.getOS();
        HBAAsset[] hBAAssetArray = this.host.getHBAs(null, null);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < hBAAssetArray.length) {
            if (n > 0) {
                stringBuffer.append("|");
            }
            stringBuffer.append(Utils.createDuplet(hBAAssetArray[n].getKey(), hBAAssetArray[n].getPath()));
            ++n;
        }
        stringArray[2] = stringBuffer.toString();
        stringArray[3] = "";
        stringArray[3] = this.host.getAnnotation();
        return stringArray;
    }

    private void _fillError(String string, String[] stringArray) {
        if (stringArray != null && stringArray.length > 1) {
            stringArray[1] = string;
        }
    }

    static void main(String[] stringArray) throws Exception {
        HostDetailCommand hostDetailCommand = new HostDetailCommand("sydney.central", null);
        hostDetailCommand.run();
        String[] stringArray2 = hostDetailCommand.getValues();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("->" + stringArray2[n]);
            ++n;
        }
    }
}

