/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.host;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.host.HostConnectivityCommand;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HostConnectivityServlet
extends HttpServlet {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.host.Localization";
    static final String HOST_PARAM = "id";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void destroy() {
    }

    protected PrintWriter writePageStart(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        HTMLTags.addTimestamp(httpServletRequest, "start");
        Masthead.getMasthead(this.getServletContext()).printMasthead(httpServletRequest, httpServletResponse, NSMPages.HOST_CONNECTIVITY_PAGE);
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println(HTMLTags.getBreadCrumbTag(httpServletRequest, NSMPages.HOST_CONNECTIVITY_PAGE));
        String string = HTMLTags.createURL(httpServletRequest.getRequestURI(), httpServletRequest.getQueryString());
        printWriter.println(HTMLTags.getContentStartTags(string));
        printWriter.println(HTMLTags.getPendingMessagesTag(httpServletRequest));
        printWriter.flush();
        HTMLTags.addTimestamp(httpServletRequest, "masthead");
        return printWriter;
    }

    protected void writePageEnd(HttpServletRequest httpServletRequest, PrintWriter printWriter) throws IOException, ServletException {
        printWriter.println(HTMLTags.getPendingMessagesTag(httpServletRequest));
        printWriter.println(HTMLTags.getTimestampTags(httpServletRequest));
        printWriter.println(HTMLTags.getContentEndTags());
        printWriter.close();
    }

    private void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        if (!this.performSecurityCheck(httpServletRequest, httpServletResponse)) {
            return;
        }
        PrintWriter printWriter = this.writePageStart(httpServletRequest, httpServletResponse);
        try {
            String string = httpServletRequest.getParameter(HOST_PARAM);
            HostConnectivityCommand hostConnectivityCommand = new HostConnectivityCommand(string, true);
            if (httpServletRequest.getParameter("stubDB") != null) {
                hostConnectivityCommand.stubData();
            }
            if (!hostConnectivityCommand.run()) {
                HTMLTags.addTimestamp(httpServletRequest, "search for host in model");
                HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString(BUNDLE, "hostNotFound"));
            } else {
                HTMLTags.addTimestamp(httpServletRequest, "search for host in model");
                int n = hostConnectivityCommand.getRowCount();
                HTMLTags.TableInfo tableInfo = HTMLTags.getTableInfo(httpServletRequest, 1, n);
                String[][] stringArray = hostConnectivityCommand.getTableData(tableInfo);
                HTMLTags.addTimestamp(httpServletRequest, "get data from model");
                printWriter.println(HTMLTags.getTableTitleTag(Localization.getString(BUNDLE, "hostConnectivity", HTMLTags.getLinkTag(HTMLTags.modifyURLParameter(NSMPages.getPageURL(NSMPages.HOST_DETAILS_PAGE), HOST_PARAM, string), hostConnectivityCommand.getHostName())), tableInfo.firstRow, n, tableInfo.pageSize));
                printWriter.println(HTMLTags.getTableTag(HTMLTags.createURL(httpServletRequest.getRequestURI(), httpServletRequest.getQueryString()), HostConnectivityCommand.getColumns(), stringArray, tableInfo.sortColumn, tableInfo.firstRow, n, tableInfo.pageSize));
                HTMLTags.addTimestamp(httpServletRequest, "write table");
            }
        }
        catch (NSMUIException nSMUIException) {
            printWriter.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.HOST_CONNECTIVITY_PAGE, nSMUIException));
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            printWriter.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.HOST_CONNECTIVITY_PAGE, new DataRetrievalException(throwable)));
        }
        this.writePageEnd(httpServletRequest, printWriter);
    }

    private boolean performSecurityCheck(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, HTMLTags.createURL(httpServletRequest.getRequestURI(), httpServletRequest.getQueryString()));
        }
        catch (LoginException loginException) {
            return false;
        }
        return true;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "NSM Host Connectivity Servlet";
    }
}

