/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.common.clip.StatementOption;
import com.sun.netstorage.mgmt.nsmui.admin.UsersCommand;
import com.sun.netstorage.mgmt.nsmui.cli.CLIUtils;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;
import java.util.Arrays;

public class UsersCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.UsersCLI";
    private static final String ADMIN_BUNDLE = "com.sun.netstorage.mgmt.nsmui.admin.Localization";
    private static final int DEFAULT_SORT_COL = 2;
    private static final TableColumn[] COLUMNS = new TableColumn[]{null, new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.admin.Localization", "users_table_title_users"), false, "\"right\""), new TableColumn(Localization.getString("com.sun.netstorage.mgmt.nsmui.admin.Localization", "users_table_title_role"), false, "\"left\"")};
    private static final CommandOption[] OPTIONS = new CommandOption[]{CommandOption.newOption('s', "sort", false), CommandOption.newOption('r', "reverse", false)};

    public UsersCLICommand() {
        super(BUNDLE, "Users", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Utils.cliSecurityCheck("Admin");
        try {
            UsersCommand usersCommand = new UsersCommand();
            usersCommand.run();
            int n = 2;
            StatementOption statementOption = statement.getOption('s');
            if (statementOption != null) {
                n = new Integer(statementOption.getArgument()) + 1;
            }
            if ((statementOption = statement.getOption('r')) != null) {
                n = new Integer("-" + statementOption.getArgument()) - 1;
            }
            String[][] stringArray = usersCommand.getUsers();
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2][2] = Localization.getString(ADMIN_BUNDLE, stringArray[n2][2]);
                ++n2;
            }
            Arrays.sort(stringArray, new SmartColumnComparator(n));
            CLIUtils.printTable(printWriter, COLUMNS, stringArray);
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "users_retrieval_error"), 99);
        }
    }
}

