/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.nsmui.admin.AttributeCommand;
import com.sun.netstorage.mgmt.nsmui.admin.LoggingCommand;
import com.sun.netstorage.mgmt.nsmui.alarms.AlarmsCommand;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.discovery.DiscoveryCommand;
import com.sun.netstorage.mgmt.nsmui.notification.EmailCommand;
import com.sun.netstorage.mgmt.nsmui.notification.SNMPCommand;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class SetPropertyCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.SetPropertyCLI";
    private static final String ADMIN_BUNDLE = "com.sun.netstorage.mgmt.nsmui.admin.Localization";
    private static final CommandOption[] OPTIONS = new CommandOption[0];
    private static final String[] levels = new String[]{"down", "critical", "major", "minor"};
    private static final String[] valid_options = new String[]{"on", "off"};
    private static final String ALARM_EXP = Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.SetPropertyCLI", "alarm-expiration");
    private static final String DIS_INT = Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.SetPropertyCLI", "discovery-interval");
    private static final String CONTACT = Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.SetPropertyCLI", "contact-email");
    private static final String THRESHOLD = Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.SetPropertyCLI", "logging-threshold");
    private static final String SMTP = Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.SetPropertyCLI", "smtp-server");
    private static final String T3_APP = Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.SetPropertyCLI", "t3-application");
    private static final String T4_APP = Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.SetPropertyCLI", "t4-application");
    private static final String EMAIL = Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.SetPropertyCLI", "email-notification");
    private static final String SNMP = Localization.getString("com.sun.netstorage.mgmt.nsmui.cli.SetPropertyCLI", "snmp-notification");

    public SetPropertyCLICommand() {
        super(BUNDLE, "SetProperty", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Utils.cliSecurityCheck("Admin");
        String[] stringArray = statement.getOperands();
        if (stringArray == null || stringArray.length != 2) {
            throw new StatementException(Localization.getString(BUNDLE, "no_operands"));
        }
        if (stringArray[0].equalsIgnoreCase(ALARM_EXP)) {
            this.setAlarmExpiration(stringArray[1]);
        } else if (stringArray[0].equalsIgnoreCase(DIS_INT)) {
            this.setDiscoveryInterval(stringArray[1]);
        } else if (stringArray[0].equalsIgnoreCase(CONTACT)) {
            this.setContactEmail(stringArray[1]);
        } else if (stringArray[0].equalsIgnoreCase(THRESHOLD)) {
            this.setLoggingThreshold(stringArray[1]);
        } else if (stringArray[0].equalsIgnoreCase(SMTP)) {
            this.setSMTPServer(stringArray[1]);
        } else if (stringArray[0].equalsIgnoreCase(T3_APP)) {
            this.setT3Application(stringArray[1]);
        } else if (stringArray[0].equalsIgnoreCase(T4_APP)) {
            this.setT4Application(stringArray[1]);
        } else if (stringArray[0].equalsIgnoreCase(EMAIL)) {
            this.setEmainNotification(stringArray[1]);
        } else if (stringArray[0].equalsIgnoreCase(SNMP)) {
            this.setSNMPNotification(stringArray[1]);
        } else {
            throw new StatementException(Localization.getString(BUNDLE, "illegal_property", stringArray[0]));
        }
    }

    private void setAlarmExpiration(String string) throws CommandException, StatementException {
        try {
            AlarmsCommand alarmsCommand = new AlarmsCommand();
            alarmsCommand.run();
            alarmsCommand.setExpirationTime(this.parseTimeValue(string, true));
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException.getCause(), Localization.getString(BUNDLE, "alarm_setting_error"), 99);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CommandException(numberFormatException, Localization.getString(BUNDLE, "invalid_time"), 99);
        }
    }

    private void setDiscoveryInterval(String string) throws CommandException, StatementException {
        try {
            DiscoveryCommand discoveryCommand = new DiscoveryCommand();
            discoveryCommand.setRefreshInterval(this.parseTimeValue(string, false));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CommandException(numberFormatException, Localization.getString(BUNDLE, "invalid_time"), 99);
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "polling_setting_error"), 99);
        }
        catch (Exception exception) {
            throw new CommandException(exception, Localization.getString(BUNDLE, "polling_setting_error"), 99);
        }
    }

    private void setContactEmail(String string) throws CommandException, StatementException {
        try {
            AttributeCommand attributeCommand = new AttributeCommand();
            attributeCommand.run();
            attributeCommand.setAttribute("contactemail", string);
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException.getCause(), Localization.getString(BUNDLE, "contact_setting_error"), 99);
        }
    }

    private void setLoggingThreshold(String string) throws CommandException, StatementException {
        block5: {
            try {
                LoggingCommand loggingCommand = new LoggingCommand();
                loggingCommand.run();
                boolean bl = false;
                int n = 0;
                while (n < levels.length) {
                    if (string.equalsIgnoreCase(levels[n])) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (bl) {
                    loggingCommand.setLoggingThreshold(Integer.parseInt(Utils.mapTokenToSeverity(string.toLowerCase())));
                    break block5;
                }
                throw new StatementException(Localization.getString(BUNDLE, "logging_invalid_level", levels));
            }
            catch (NSMUIException nSMUIException) {
                throw new CommandException(nSMUIException.getCause(), Localization.getString(BUNDLE, "logging_retrieval_error"), 99);
            }
        }
    }

    private void setSMTPServer(String string) throws CommandException, StatementException {
        String string2 = null;
        try {
            EmailCommand emailCommand = new EmailCommand();
            emailCommand.run();
            string2 = emailCommand.setSMTPHost(string);
            if (string2 != null) {
                throw new StatementException(string2);
            }
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "smtp_write_error"), 99);
        }
    }

    private void setT3Application(String string) throws CommandException, StatementException {
        block7: {
            try {
                AttributeCommand attributeCommand = new AttributeCommand();
                attributeCommand.run();
                StringTokenizer stringTokenizer = new StringTokenizer(Localization.getString(ADMIN_BUNDLE, "t3_applications"), " ");
                String[] stringArray = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreElements()) {
                    stringArray[n] = (String)stringTokenizer.nextElement();
                    ++n;
                }
                boolean bl = false;
                string = string.toLowerCase();
                n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].equals(string)) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (bl) {
                    attributeCommand.setAttribute("t3management", string);
                    break block7;
                }
                Object[] objectArray = new String[stringArray.length];
                n = 0;
                while (n < stringArray.length) {
                    objectArray[n] = Localization.getString(ADMIN_BUNDLE, stringArray[n] + ".cli");
                    ++n;
                }
                throw new StatementException(Localization.getString(ADMIN_BUNDLE, "t3_valid_names", objectArray));
            }
            catch (NSMUIException nSMUIException) {
                throw new CommandException(nSMUIException.getCause(), Localization.getString(BUNDLE, "app_setting_error"), 99);
            }
        }
    }

    private void setT4Application(String string) throws CommandException, StatementException {
        block7: {
            try {
                AttributeCommand attributeCommand = new AttributeCommand();
                attributeCommand.run();
                StringTokenizer stringTokenizer = new StringTokenizer(Localization.getString(ADMIN_BUNDLE, "t4_applications"), " ");
                String[] stringArray = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreElements()) {
                    stringArray[n] = (String)stringTokenizer.nextElement();
                    ++n;
                }
                boolean bl = false;
                string = string.toLowerCase();
                n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].equals(string)) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (bl) {
                    attributeCommand.setAttribute("t4management", string);
                    break block7;
                }
                Object[] objectArray = new String[stringArray.length];
                n = 0;
                while (n < stringArray.length) {
                    objectArray[n] = Localization.getString(ADMIN_BUNDLE, stringArray[n] + ".cli");
                    ++n;
                }
                throw new StatementException(Localization.getString(ADMIN_BUNDLE, "t4_valid_names", objectArray));
            }
            catch (NSMUIException nSMUIException) {
                throw new CommandException(nSMUIException.getCause(), Localization.getString(BUNDLE, "app_setting_error"), 99);
            }
        }
    }

    private void setEmainNotification(String string) throws CommandException, StatementException {
        block4: {
            try {
                EmailCommand emailCommand = new EmailCommand();
                emailCommand.run();
                if (string.equalsIgnoreCase(valid_options[0])) {
                    emailCommand.pause(false);
                    break block4;
                }
                if (string.equalsIgnoreCase(valid_options[1])) {
                    emailCommand.pause(true);
                    break block4;
                }
                throw new StatementException(Localization.getString(BUNDLE, "valid_options", valid_options));
            }
            catch (NSMUIException nSMUIException) {
                throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "email_setting_error"), 99);
            }
        }
    }

    private void setSNMPNotification(String string) throws CommandException, StatementException {
        block4: {
            try {
                SNMPCommand sNMPCommand = new SNMPCommand();
                sNMPCommand.run();
                if (string.equalsIgnoreCase(valid_options[0])) {
                    sNMPCommand.pause(false);
                    break block4;
                }
                if (string.equalsIgnoreCase(valid_options[1])) {
                    sNMPCommand.pause(true);
                    break block4;
                }
                throw new StatementException(Localization.getString(BUNDLE, "valid_options", valid_options));
            }
            catch (NSMUIException nSMUIException) {
                throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "snmp_setting_error"), 99);
            }
        }
    }

    private long parseTimeValue(String string, boolean bl) throws NumberFormatException {
        String string2 = string.toLowerCase();
        long l = 0L;
        int n = 0;
        n = string2.indexOf(109);
        if (n >= 0) {
            string2 = string2.substring(0, n);
            l = Long.parseLong(string2) * 60L * 1000L;
        } else {
            n = string2.indexOf(104);
            if (n >= 0) {
                string2 = string2.substring(0, n);
                l = Long.parseLong(string2) * 60L * 60L * 1000L;
            } else {
                n = string2.indexOf(100);
                if (n >= 0) {
                    string2 = string2.substring(0, n);
                    l = Long.parseLong(string2) * 24L * 60L * 60L * 1000L;
                } else {
                    l = Long.parseLong(string2) * 60L * 1000L;
                }
            }
        }
        if (bl) {
            Long.parseLong(String.valueOf(l));
        } else {
            Integer.parseInt(String.valueOf(l));
        }
        return l;
    }
}

