/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.nsmui.cli.CLIUtils;
import com.sun.netstorage.mgmt.nsmui.cli.TopologyCLICommand;
import com.sun.netstorage.mgmt.nsmui.topology.TopologyCommand;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.services.topology.FabricTopology;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyElementNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class PathsCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.PathsCLI";
    private static final String TOPO_BUNDLE = "com.sun.netstorage.mgmt.nsmui.topology.Localization";
    private static final CommandOption[] OPTIONS = new CommandOption[0];

    public PathsCLICommand() {
        super(BUNDLE, "Paths", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        TSTopologyNode[][] tSTopologyNodeArray;
        String[] stringArray = statement.getOperands();
        if (stringArray.length != 2) {
            throw new StatementException(Localization.getString(BUNDLE, "incorrectOperandCount"));
        }
        ArrayList arrayList = new ArrayList();
        TopologyCommand topologyCommand = new TopologyCommand();
        SanTopology sanTopology = null;
        try {
            sanTopology = TopologyCLICommand.getSanTopology();
        }
        catch (TopologyElementNotFoundException topologyElementNotFoundException) {
            throw new CommandException(topologyElementNotFoundException, Localization.getString(BUNDLE, "topologyServiceUnreachable"), 99);
        }
        FabricTopology[] fabricTopologyArray = sanTopology.getFabrics();
        int n = 0;
        while (n < fabricTopologyArray.length) {
            tSTopologyNodeArray = topologyCommand.getPathsBetween(fabricTopologyArray[n].getPhysicalTopology(), stringArray);
            if (tSTopologyNodeArray != null) {
                arrayList.addAll(Arrays.asList(tSTopologyNodeArray));
            }
            ++n;
        }
        tSTopologyNodeArray = topologyCommand.getPathsBetween(sanTopology.getDasTopology(), stringArray);
        if (tSTopologyNodeArray != null) {
            arrayList.addAll(Arrays.asList(tSTopologyNodeArray));
        }
        TSTopologyNode[][] tSTopologyNodeArray2 = (TSTopologyNode[][])arrayList.toArray((T[])new TSTopologyNode[0][arrayList.size()]);
        this.printPaths(printWriter, tSTopologyNodeArray2);
    }

    public void printPaths(PrintWriter printWriter, TSTopologyNode[][] tSTopologyNodeArray) {
        if (tSTopologyNodeArray.length == 0) {
            printWriter.println(Localization.getString(TOPO_BUNDLE, "noPathsFound"));
            return;
        }
        String string = null;
        TSTopologyNode tSTopologyNode = tSTopologyNodeArray[0][0].getImmediateParent();
        if (tSTopologyNode != null) {
            string = (String)tSTopologyNode.getProperty("Name");
        }
        if (string == null) {
            string = "";
        }
        int n = 2;
        int n2 = 0;
        while (n2 < tSTopologyNodeArray.length) {
            n = Math.max(n, tSTopologyNodeArray[n2].length);
            ++n2;
        }
        TableColumn tableColumn = new TableColumn(Localization.getString(TOPO_BUNDLE, "deviceColumn"), true, "\"left\"");
        Object[] objectArray = new TableColumn[n];
        Arrays.fill(objectArray, tableColumn);
        objectArray[0] = new TableColumn(Localization.getString(BUNDLE, "hostColumn"), true, "\"left\"");
        String[][] stringArray = new String[tSTopologyNodeArray.length][0];
        int n3 = 0;
        while (n3 < tSTopologyNodeArray.length) {
            stringArray[n3] = new String[tSTopologyNodeArray[n3].length];
            stringArray[n3][0] = string;
            int n4 = 1;
            while (n4 < tSTopologyNodeArray[n3].length) {
                stringArray[n3][n4] = (String)tSTopologyNodeArray[n3][n4].getProperty("Name");
                ++n4;
            }
            ++n3;
        }
        CLIUtils.printTable(printWriter, (TableColumn[])objectArray, stringArray);
    }
}

