/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.common.clip.StatementOption;
import com.sun.netstorage.mgmt.nsmui.cli.CLIUtils;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.notification.EmailCommand;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.service.notification.ContractSpecificationException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ModifyEmailNotificationCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.ModifyEmailNotificationCLI";
    private static final String NOTIFICATION_BUNDLE = "com.sun.netstorage.mgmt.nsmui.notification.Localization";
    private static final String[] levels = new String[]{"down", "critical", "major", "minor"};
    private static final String[] mediums = new String[]{"email", "pager"};
    private static final CommandOption[] OPTIONS = new CommandOption[]{CommandOption.newOption('m', "medium", false), CommandOption.newOption('e', "email-address", false), CommandOption.newOption('t', "min-interval", false), CommandOption.newOption('l', "locale", false)};
    private static final String[] fields = new String[]{Localization.getString("com.sun.netstorage.mgmt.nsmui.notification.Localization", "email_table_title_id"), Localization.getString("com.sun.netstorage.mgmt.nsmui.notification.Localization", "email_table_title_level"), Localization.getString("com.sun.netstorage.mgmt.nsmui.notification.Localization", "email_table_title_medium"), Localization.getString("com.sun.netstorage.mgmt.nsmui.notification.Localization", "email_table_title_address"), Localization.getString("com.sun.netstorage.mgmt.nsmui.notification.Localization", "email_table_title_time"), Localization.getString("com.sun.netstorage.mgmt.nsmui.notification.Localization", "email_table_title_locale")};
    private String[] data = new String[6];

    public ModifyEmailNotificationCLICommand() {
        super(BUNDLE, "ModifyEmailNotification", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Utils.cliSecurityCheck("Admin");
        boolean bl = false;
        try {
            EmailCommand emailCommand = new EmailCommand();
            emailCommand.run();
            String[] stringArray = statement.getOperands();
            if (stringArray == null || stringArray.length == 0) {
                throw new StatementException(Localization.getString(BUNDLE, "email_notification_no_id"));
            }
            Hashtable hashtable = emailCommand.getContract(stringArray[0]);
            if (hashtable == null) {
                throw new StatementException(Localization.getString(BUNDLE, "email_notification_unknown_id", stringArray[0]));
            }
            String string = (String)hashtable.get("IsPager") == "no" ? "email" : "pager";
            String string2 = (String)hashtable.get("To");
            String string3 = (String)hashtable.get("NotificationInterval");
            String string4 = (String)hashtable.get("Locale");
            StatementOption statementOption = statement.getOption('m');
            if (statementOption != null) {
                string = statementOption.getArgument();
                if (!string.equalsIgnoreCase(mediums[0]) && !string.equalsIgnoreCase(mediums[1])) {
                    throw new StatementException(Localization.getString(BUNDLE, "email_invalid_medium", mediums));
                }
                bl = true;
            }
            if ((statementOption = statement.getOption('e')) != null) {
                string2 = statementOption.getArgument();
                bl = true;
            }
            if ((statementOption = statement.getOption('t')) != null) {
                string3 = statementOption.getArgument();
                bl = true;
            }
            if ((statementOption = statement.getOption('l')) != null) {
                String string5 = Localization.getString(NOTIFICATION_BUNDLE, statementOption.getArgument().toLowerCase());
                StringTokenizer stringTokenizer = new StringTokenizer(Localization.getString(NOTIFICATION_BUNDLE, "available_locales"), " ");
                String[] stringArray2 = new String[stringTokenizer.countTokens()];
                Object[] objectArray = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreElements()) {
                    stringArray2[n] = (String)stringTokenizer.nextElement();
                    objectArray[n] = Localization.getString(NOTIFICATION_BUNDLE, stringArray2[n]);
                    ++n;
                }
                boolean bl2 = false;
                n = 0;
                while (n < stringArray2.length) {
                    if (stringArray2[n].equals(string5)) {
                        string4 = string5;
                        bl2 = true;
                        break;
                    }
                    ++n;
                }
                if (!bl2) {
                    throw new StatementException(Localization.getString(NOTIFICATION_BUNDLE, "invalid_locale", objectArray));
                }
                bl = true;
            }
            if (bl) {
                emailCommand.modContract(stringArray[0], string2, string, string3, string4);
            } else {
                this.data[0] = stringArray[0];
                this.data[1] = Localization.getString(NOTIFICATION_BUNDLE, Utils.mapSeverityToToken((String)hashtable.get("Criteria")));
                this.data[2] = Localization.getString(NOTIFICATION_BUNDLE, this.getPager(string));
                this.data[3] = string2;
                this.data[4] = this.getPeriod(string3);
                this.data[5] = Localization.getString(NOTIFICATION_BUNDLE, string4);
                CLIUtils.printDetail(printWriter, fields, this.data);
            }
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException.getCause(), Localization.getString(BUNDLE, "email_retrieval_error"), 99);
        }
        catch (ContractSpecificationException contractSpecificationException) {
            throw new CommandException(contractSpecificationException, Localization.getString(BUNDLE, "email_retrieval_error"), 99);
        }
    }

    private String getPager(String string) {
        return string.equals("yes") ? Localization.getString(BUNDLE, "pager") : Localization.getString(BUNDLE, "email");
    }

    private String getPeriod(String string) {
        String string2 = " " + Localization.getString(BUNDLE, "minutes");
        long l = Long.parseLong(string);
        long l2 = 0L;
        if (l != 0L) {
            if (l % 1440L == 0L) {
                l2 = l / 1440L;
                string2 = " " + Localization.getString(BUNDLE, "days");
            } else if (l % 60L == 0L) {
                l2 = l / 60L;
                string2 = " " + Localization.getString(BUNDLE, "hours");
            } else {
                l2 = l;
                string2 = " " + Localization.getString(BUNDLE, "minutes");
            }
        }
        return String.valueOf(l2) + string2;
    }
}

