/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.common.clip.StatementOption;
import com.sun.netstorage.mgmt.nsmui.cli.CLIUtils;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.notification.EmailCommand;
import com.sun.netstorage.mgmt.nsmui.util.SmartColumnComparator;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;
import java.util.Arrays;

public class EmailNotificationsCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.EmailNotificationsCLI";
    private static final String NOTIFICATION_BUNDLE = "com.sun.netstorage.mgmt.nsmui.notification.Localization";
    private static final int DEFAULT_SORT_COL = -2;
    private static final TableColumn[] COLUMNS = new TableColumn[6];
    private static final int ID_COLUMN = 0;
    private static final int LEVEL_COLUMN = 1;
    private static final int PAGER_COLUMN = 2;
    private static final int ADDRESS_COLUMN = 3;
    private static final int TIME_COLUMN = 4;
    private static final int LOCALE_COLUMN = 5;
    private EmailCommand emailCommand;
    private static final CommandOption[] OPTIONS = new CommandOption[]{CommandOption.newOption('s', "sort", false), CommandOption.newOption('r', "reverse", false)};

    public EmailNotificationsCLICommand() {
        super(BUNDLE, "EmailNotifications", OPTIONS);
        if (COLUMNS[0] == null) {
            EmailNotificationsCLICommand.COLUMNS[0] = new TableColumn(Localization.getString(NOTIFICATION_BUNDLE, "email_table_title_id"), true, "\"left\"");
            EmailNotificationsCLICommand.COLUMNS[1] = new TableColumn(Localization.getString(NOTIFICATION_BUNDLE, "email_table_title_level"), true, "\"left\"");
            EmailNotificationsCLICommand.COLUMNS[2] = new TableColumn(Localization.getString(NOTIFICATION_BUNDLE, "email_table_title_medium"), true, "\"left\"");
            EmailNotificationsCLICommand.COLUMNS[3] = new TableColumn(Localization.getString(NOTIFICATION_BUNDLE, "email_table_title_address"), true, "\"left\"");
            EmailNotificationsCLICommand.COLUMNS[4] = new TableColumn(Localization.getString(NOTIFICATION_BUNDLE, "email_table_title_time"), true, "\"right\"");
            EmailNotificationsCLICommand.COLUMNS[5] = new TableColumn(Localization.getString(NOTIFICATION_BUNDLE, "email_table_title_locale"), true, "\"left\"");
        }
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Utils.cliSecurityCheck("Admin");
        try {
            String[][] stringArray;
            this.emailCommand = new EmailCommand();
            this.emailCommand.run();
            int n = -2;
            StatementOption statementOption = statement.getOption('s');
            if (statementOption != null) {
                n = new Integer(statementOption.getArgument());
            }
            if ((statementOption = statement.getOption('r')) != null) {
                n = new Integer("-" + statementOption.getArgument());
            }
            if ((stringArray = this.emailCommand.getContracts()).length > 0) {
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    stringArray[n3][5] = Localization.getString(NOTIFICATION_BUNDLE, stringArray[n3][5]);
                    ++n3;
                }
                Arrays.sort(stringArray, new SmartColumnComparator(n));
                int n4 = 0;
                while (n4 < n2) {
                    stringArray[n4][1] = Localization.getString(NOTIFICATION_BUNDLE, Utils.mapSeverityToToken(stringArray[n4][1]));
                    ++n4;
                }
                int n5 = 0;
                while (n5 < n2) {
                    stringArray[n5][2] = Localization.getString(NOTIFICATION_BUNDLE, this.getPager(stringArray[n5][2]));
                    ++n5;
                }
                int n6 = 0;
                while (n6 < n2) {
                    stringArray[n6][4] = this.getPeriod(stringArray[n6][4]);
                    ++n6;
                }
                if (stringArray == null) {
                    printWriter.println(Localization.getString(NOTIFICATION_BUNDLE, "no_email_contracts"));
                } else {
                    CLIUtils.printTable(printWriter, COLUMNS, stringArray);
                }
            } else {
                printWriter.println(Localization.getString(NOTIFICATION_BUNDLE, "no_email_contracts"));
            }
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "email_retrieval_error"), 99);
        }
    }

    private String getPager(String string) {
        return string.equals("yes") ? Localization.getString(BUNDLE, "pager") : Localization.getString(BUNDLE, "email");
    }

    private String getPeriod(String string) {
        String string2 = " " + Localization.getString(BUNDLE, "minutes");
        long l = Long.parseLong(string);
        long l2 = 0L;
        if (l != 0L) {
            if (l % 1440L == 0L) {
                l2 = l / 1440L;
                string2 = " " + Localization.getString(BUNDLE, "days");
            } else if (l % 60L == 0L) {
                l2 = l / 60L;
                string2 = " " + Localization.getString(BUNDLE, "hours");
            } else {
                l2 = l;
                string2 = " " + Localization.getString(BUNDLE, "minutes");
            }
        }
        return String.valueOf(l2) + string2;
    }
}

