/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.notification.EmailCommand;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;

public class DeleteEmailNotificationCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.DeleteEmailNotificationCLI";
    EmailCommand emailCommand;
    private static final CommandOption[] OPTIONS = new CommandOption[0];

    public DeleteEmailNotificationCLICommand() {
        super(BUNDLE, "DeleteEmailNotification", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        block5: {
            Utils.cliSecurityCheck("Admin");
            String[] stringArray = statement.getOperands();
            if (stringArray == null || stringArray.length == 0) {
                throw new StatementException(Localization.getString(BUNDLE, "del_email_notification_no_id"));
            }
            try {
                this.emailCommand = new EmailCommand();
                this.emailCommand.run();
                if (this.emailCommand.getContract(stringArray[0]) != null) {
                    int n = 0;
                    while (n < stringArray.length) {
                        this.emailCommand.deleteContract(stringArray[n]);
                        printWriter.println(Localization.getString(BUNDLE, "removed"));
                        ++n;
                    }
                    break block5;
                }
                throw new StatementException(Localization.getString(BUNDLE, "del_email_notification_unknown_id", stringArray[0]));
            }
            catch (NSMUIException nSMUIException) {
                throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "del_email_notification_error"), 99);
            }
        }
    }
}

