/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.nsmui.alarms.AlarmsCommand;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;

public class DeleteAlarmCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.DeleteAlarmCLI";
    private static final String ALARMS_BUNDLE = "com.sun.netstorage.mgmt.nsmui.alarms.Localization";
    private static final CommandOption[] OPTIONS = new CommandOption[0];

    public DeleteAlarmCLICommand() {
        super(BUNDLE, "DeleteAlarm", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Utils.cliSecurityCheck("Admin");
        String[] stringArray = statement.getOperands();
        if (stringArray == null || stringArray.length == 0) {
            throw new StatementException(Localization.getString(BUNDLE, "alarm_no_id"));
        }
        String string = "";
        try {
            AlarmsCommand alarmsCommand = new AlarmsCommand();
            alarmsCommand.run();
            int n = 0;
            while (n < stringArray.length) {
                string = stringArray[n];
                String string2 = alarmsCommand.getAlarm(string)[0];
                if (string2 == null) {
                    throw new StatementException(Localization.getString(BUNDLE, "alarm_no_alarm", string));
                }
                alarmsCommand.deleteAlarm(alarmsCommand.getFullAlarmID(string));
                printWriter.println(Localization.getString(BUNDLE, "removed"));
                ++n;
            }
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "alarm_retrieval_error"), 99);
        }
        catch (Exception exception) {
            throw new CommandException(exception, Localization.getString(BUNDLE, "alarm_unknown_alarm_id", string), 99);
        }
    }
}

