/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.nsmui.admin.IPAdminCommand;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;

public class DeleteAddressCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.DeleteAddressCLI";
    private static final CommandOption[] OPTIONS = new CommandOption[0];

    public DeleteAddressCLICommand() {
        super(BUNDLE, "DeleteAddress", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Utils.cliSecurityCheck("Admin");
        String[] stringArray = statement.getOperands();
        if (stringArray == null || stringArray.length == 0) {
            throw new StatementException(Localization.getString(BUNDLE, "addresses_no_address"));
        }
        try {
            IPAdminCommand iPAdminCommand = new IPAdminCommand();
            iPAdminCommand.run();
            int n = 0;
            while (n < stringArray.length) {
                String string = iPAdminCommand.getUsername(stringArray[n]);
                if (string == null) {
                    throw new StatementException(Localization.getString(BUNDLE, "addresses_unknown_address", stringArray[n]));
                }
                iPAdminCommand.deleteAgentKey(stringArray[n]);
                printWriter.println(Localization.getString(BUNDLE, "removed"));
                ++n;
            }
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "addresses_write_error"), 99);
        }
    }
}

