/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.nsmui.cli.CLIUtils;
import com.sun.netstorage.mgmt.nsmui.cli.TopologyCLICommand;
import com.sun.netstorage.mgmt.nsmui.common.DataRetrievalException;
import com.sun.netstorage.mgmt.nsmui.topology.DASDetailCommand;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import java.io.PrintWriter;

public class DASCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.DASCLI";
    private static final CommandOption[] OPTIONS = new CommandOption[0];

    public DASCLICommand() {
        super(BUNDLE, "DAS", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        String[] stringArray = statement.getOperands();
        if (stringArray.length > 1) {
            throw new StatementException(Localization.getString(BUNDLE, "incorrectOperandCount"));
        }
        String string = stringArray.length == 1 ? stringArray[0] : null;
        SanTopology sanTopology = null;
        try {
            sanTopology = TopologyCLICommand.getSanTopology();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new CommandException(throwable, Localization.getString(BUNDLE, "exception"), 99);
        }
        if (sanTopology == null || sanTopology.getDasNodeCount() == 0) {
            printWriter.println(Localization.getString(BUNDLE, "noDASFound"));
            return;
        }
        try {
            DASDetailCommand dASDetailCommand = new DASDetailCommand(sanTopology, string, false);
            dASDetailCommand.run();
            CLIUtils.printTable(printWriter, DASDetailCommand.getColumns(), dASDetailCommand.getTableData(null));
        }
        catch (DataRetrievalException dataRetrievalException) {
            throw new CommandException(dataRetrievalException.getCause() != null ? dataRetrievalException.getCause() : dataRetrievalException, dataRetrievalException.getMessage(), 99);
        }
    }
}

