/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.nsmui.alarms.AlarmsCommand;
import com.sun.netstorage.mgmt.nsmui.cli.CLIUtils;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import java.io.PrintWriter;
import java.util.Date;

public class AlarmCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.AlarmCLI";
    private static final String ALARMS_BUNDLE = "com.sun.netstorage.mgmt.nsmui.alarms.Localization";
    private static final String[] fields = new String[]{Localization.getString("com.sun.netstorage.mgmt.nsmui.alarms.Localization", "details_description"), Localization.getString("com.sun.netstorage.mgmt.nsmui.alarms.Localization", "details_time"), Localization.getString("com.sun.netstorage.mgmt.nsmui.alarms.Localization", "details_details")};
    private String[] data = new String[3];
    private static final CommandOption[] OPTIONS = new CommandOption[0];

    public AlarmCLICommand() {
        super(BUNDLE, "Alarm", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Utils.cliSecurityCheck("Guest");
        String[] stringArray = statement.getOperands();
        if (stringArray == null || stringArray.length == 0) {
            throw new StatementException(Localization.getString(BUNDLE, "alarm_no_id"));
        }
        try {
            AlarmsCommand alarmsCommand = new AlarmsCommand();
            alarmsCommand.run();
            String[] stringArray2 = alarmsCommand.getAlarm(stringArray[0]);
            if (stringArray2 == null || stringArray2[0] == null) {
                throw new StatementException(Localization.getString(BUNDLE, "alarm_unknown_alarm_id"));
            }
            this.data[0] = stringArray2[1];
            this.data[1] = new Date(Long.parseLong(stringArray2[2])).toString();
            this.data[2] = stringArray2[3];
            CLIUtils.printDetail(printWriter, fields, this.data);
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException, Localization.getString(BUNDLE, "alarm_retrieval_error"), 99);
        }
        catch (Exception exception) {
            throw new CommandException(exception, Localization.getString(BUNDLE, "alarm_unknown_alarm_id"), 99);
        }
    }
}

