/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.cli;

import com.sun.netstorage.mgmt.common.clip.AbstractCommand;
import com.sun.netstorage.mgmt.common.clip.CommandException;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.common.clip.Statement;
import com.sun.netstorage.mgmt.common.clip.StatementException;
import com.sun.netstorage.mgmt.common.clip.StatementOption;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.notification.EmailCommand;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.service.notification.ContractSpecificationException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.StringTokenizer;

public class AddEmailNotificationCLICommand
extends AbstractCommand {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.cli.AddEmailNotificationCLI";
    private static final String NOTIFICATION_BUNDLE = "com.sun.netstorage.mgmt.nsmui.notification.Localization";
    private static final String[] levels = new String[]{"down", "critical", "major", "minor"};
    private static final String[] mediums = new String[]{"email", "pager"};
    private static final CommandOption[] OPTIONS = new CommandOption[]{CommandOption.newOption('a', "alarm-level", false), CommandOption.newOption('m', "medium", false), CommandOption.newOption('e', "email-address", true), CommandOption.newOption('t', "min-interval", false), CommandOption.newOption('l', "locale", false)};

    public AddEmailNotificationCLICommand() {
        super(BUNDLE, "AddEmailNotification", OPTIONS);
    }

    public void execute(PrintWriter printWriter, Statement statement) throws CommandException, StatementException {
        Utils.cliSecurityCheck("Admin");
        try {
            String string;
            EmailCommand emailCommand = new EmailCommand();
            emailCommand.run();
            String string2 = "down";
            String string3 = "email";
            String string4 = null;
            String string5 = "0";
            String string6 = Locale.getDefault().toString();
            StatementOption statementOption = statement.getOption('a');
            if (!(statementOption == null || (string2 = statementOption.getArgument().toLowerCase()).equalsIgnoreCase(levels[0]) || string2.equalsIgnoreCase(levels[1]) || string2.equalsIgnoreCase(levels[2]) || string2.equalsIgnoreCase(levels[3]))) {
                throw new StatementException(Localization.getString(BUNDLE, "email_invalid_level", levels));
            }
            statementOption = statement.getOption('m');
            if (statementOption != null && !(string3 = statementOption.getArgument()).equalsIgnoreCase(mediums[0]) && !string3.equalsIgnoreCase(mediums[1])) {
                throw new StatementException(Localization.getString(BUNDLE, "email_invalid_medium", mediums));
            }
            statementOption = statement.getOption('e');
            if (statementOption != null) {
                string4 = statementOption.getArgument();
            }
            if ((statementOption = statement.getOption('t')) != null) {
                string5 = statementOption.getArgument();
            }
            if ((statementOption = statement.getOption('l')) != null) {
                string = Localization.getString(NOTIFICATION_BUNDLE, statementOption.getArgument().toLowerCase());
                StringTokenizer stringTokenizer = new StringTokenizer(Localization.getString(NOTIFICATION_BUNDLE, "available_locales"), " ");
                String[] stringArray = new String[stringTokenizer.countTokens()];
                Object[] objectArray = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreElements()) {
                    stringArray[n] = (String)stringTokenizer.nextElement();
                    objectArray[n] = Localization.getString(NOTIFICATION_BUNDLE, stringArray[n]);
                    ++n;
                }
                boolean bl = false;
                n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].equals(string)) {
                        string6 = string;
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    throw new StatementException(Localization.getString(NOTIFICATION_BUNDLE, "invalid_locale", objectArray));
                }
            }
            string = Localization.getString(NOTIFICATION_BUNDLE, "subject_line", Utils.formatStringToLocale(string6)) + Localization.getString(NOTIFICATION_BUNDLE, "severity_level_" + string2, Utils.formatStringToLocale(string6));
            emailCommand.addContract(string2, string4, string, string3, string5, string6);
        }
        catch (NSMUIException nSMUIException) {
            throw new CommandException(nSMUIException.getCause(), Localization.getString(BUNDLE, "email_retrieval_error"), 99);
        }
        catch (ContractSpecificationException contractSpecificationException) {
            throw new CommandException(contractSpecificationException, Localization.getString(BUNDLE, "email_retrieval_error"), 99);
        }
    }
}

