/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.admin;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.admin.UsersBean;
import com.sun.netstorage.mgmt.nsmui.admin.UsersCommand;
import com.sun.netstorage.mgmt.nsmui.common.Configuration;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UsersAdd
extends HttpServlet {
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.admin.Localization";
    private UsersCommand usersCommand = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PrintWriter out;
    private UsersBean ub;

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        this.out = httpServletResponse.getWriter();
        try {
            object = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, NSMPages.getPageURL(NSMPages.USERS_ADD_PAGE));
            if (object == null || !((String)object).equalsIgnoreCase("Admin")) {
                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "not_authorized"));
                this.displayMasthead();
                return;
            }
        }
        catch (LoginException loginException) {
            return;
        }
        object = null;
        try {
            UtilsWeb.noCacheHeader(httpServletResponse);
            this.usersCommand = new UsersCommand();
            this.usersCommand.run();
            httpServletRequest.setAttribute("UsersBeanId", (Object)this.ub);
            String string = httpServletRequest.getParameter("submitcontrol");
            if (string != null) {
                if (string.equals("savebutton")) {
                    this.setupInitialValues(false);
                    if (this.isReservedUser(this.ub.getUser())) {
                        HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "add_users_msg_reserved_user", this.ub.getUser()));
                    } else if (this.ub.getUser().length() == 0) {
                        HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "add_users_msg_empty_user"));
                    } else if (!UsersCommand.isKnownUser(this.ub.getUser(), Configuration.getProperty("PAM_VERIFIER_DIR"))) {
                        HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "add_users_msg_invalid_user", this.ub.getUser()));
                    } else if (this.usersCommand.userExists(this.ub.getUser())) {
                        HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString(BUNDLE, "add_users_msg_user_exists", this.ub.getUser()));
                    } else {
                        this.usersCommand.addUser(this.ub.getUser(), this.ub.getRole());
                        HTMLTags.addPendingMessage(httpServletRequest, "infoMessages", Localization.getString(BUNDLE, "add_users_msg_user_added"));
                    }
                    this.displayMasthead();
                    UtilsWeb.include(this.getServletContext(), "/jsp/usersadd.jsp", httpServletRequest, httpServletResponse);
                } else if (string.equals("cancelbutton")) {
                    UtilsWeb.redirect(NSMPages.getPageURL(NSMPages.ADMIN_USERS_PAGE), httpServletResponse);
                }
            } else {
                this.setupInitialValues(true);
                this.displayMasthead();
                UtilsWeb.include(this.getServletContext(), "/jsp/usersadd.jsp", httpServletRequest, httpServletResponse);
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            object = throwable instanceof NSMUIException ? (NSMUIException)throwable : new NSMUIException("", throwable);
        }
        if (object != null) {
            this.displayMasthead();
            this.out.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.USERS_ADD_PAGE, (Throwable)object));
            this.out.flush();
        }
    }

    public void setupInitialValues(boolean bl) {
        if (bl) {
            this.ub.setUser("");
            this.ub.setRole("Guest");
        } else {
            this.ub.setUser(this.request.getParameter("usertext"));
            this.ub.setRole(this.request.getParameter("roleselect"));
        }
    }

    private void displayMasthead() throws ServletException, IOException {
        UtilsWeb.noCacheHeader(this.response);
        Masthead.getMasthead(this.getServletContext()).print("Administration", "Administration", "Users", NSMPages.getPageHelp(NSMPages.USERS_ADD_PAGE), NSMPages.ADMIN_USERS_PAGE, this.request, this.response);
        this.out.println(HTMLTags.getBreadCrumbTag(this.request, NSMPages.USERS_ADD_PAGE));
        this.out.println(HTMLTags.getPendingMessagesTag(this.request));
        this.out.flush();
    }

    private boolean isReservedUser(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(Localization.getString(BUNDLE, "reserved_usernames"), " ");
        boolean bl = false;
        while (stringTokenizer.hasMoreElements()) {
            if (!((String)stringTokenizer.nextElement()).equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.ub = new UsersBean();
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public String getServletInfo() {
        return "This is the main Users Notification page.";
    }
}

