/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.admin;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.common.Configuration;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.service.logging.LogFilterCriteria;
import com.sun.netstorage.mgmt.service.logging.LoggingAdmin;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class LoggingCommand {
    private static String BUNDLE = "com.sun.netstorage.mgmt.nsmui.admin.Localization";
    LoggingAdmin lService;

    public LoggingCommand() throws NSMUIException {
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new SecurityManager());
            }
            String string = Configuration.getProperty("REGISTRY_HOST");
            Registry registry = null;
            try {
                registry = LocateRegistry.getRegistry(string, Integer.parseInt(Configuration.getProperty("NSM_RMI_REGISTRY_PORT")));
            }
            catch (NumberFormatException numberFormatException) {
                registry = LocateRegistry.getRegistry(string);
            }
            this.lService = (LoggingAdmin)registry.lookup("com.sun.netstorage.mgmt.service.nsm.logging.domestic");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_logging_service"), throwable);
        }
    }

    public void run() throws NSMUIException {
    }

    public int getLoggingThreshold() throws NSMUIException {
        try {
            LogFilterCriteria logFilterCriteria = this.lService.getFilterCriteria();
            return logFilterCriteria.getSeverityCriteria();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_logging_service"), throwable);
        }
    }

    public void setLoggingThreshold(int n) throws NSMUIException {
        try {
            LogFilterCriteria logFilterCriteria = this.lService.getFilterCriteria();
            logFilterCriteria.setSeverityCriteria(n);
            this.lService.setFilterCriteria(logFilterCriteria);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw new NSMUIException(Localization.getString(BUNDLE, "trouble_contacting_logging_service"), throwable);
        }
    }
}

