/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.nsmui.admin;

import com.sun.netstorage.mgmt.common.clip.Localization;
import com.sun.netstorage.mgmt.nsmui.admin.AdminCommand;
import com.sun.netstorage.mgmt.nsmui.admin.AttributeCommand;
import com.sun.netstorage.mgmt.nsmui.admin.LoggingCommand;
import com.sun.netstorage.mgmt.nsmui.alarms.AlarmsCommand;
import com.sun.netstorage.mgmt.nsmui.common.Configuration;
import com.sun.netstorage.mgmt.nsmui.common.LoginException;
import com.sun.netstorage.mgmt.nsmui.common.NSMUIException;
import com.sun.netstorage.mgmt.nsmui.common.Security;
import com.sun.netstorage.mgmt.nsmui.discovery.DiscoveryCommand;
import com.sun.netstorage.mgmt.nsmui.notification.EmailCommand;
import com.sun.netstorage.mgmt.nsmui.notification.SNMPCommand;
import com.sun.netstorage.mgmt.nsmui.util.HTMLTags;
import com.sun.netstorage.mgmt.nsmui.util.Masthead;
import com.sun.netstorage.mgmt.nsmui.util.NSMPages;
import com.sun.netstorage.mgmt.nsmui.util.TableColumn;
import com.sun.netstorage.mgmt.nsmui.util.Utils;
import com.sun.netstorage.mgmt.nsmui.util.UtilsWeb;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Admin
extends HttpServlet {
    private static final String PAGE_URL = "/nsm/admin";
    private static final int DEFAULT_SORT_COL = -2;
    private static final int NUMBER_OF_COLUMNS = 2;
    private static final TableColumn[] COLUMNS = new TableColumn[2];
    private static final int NAME_COLUMN = 0;
    private static final int URL_COLUMN = 1;
    private String theTable;
    private static final String BUNDLE = "com.sun.netstorage.mgmt.nsmui.admin.Localization";
    private String emailPauseValue = "on";
    private String snmpPauseValue = "on";
    private String periodValue;
    private static String[] periodItems = new String[]{"minutes", "hours", "days"};
    private String timeValue;
    private String logThresholdValue;
    private static String[] logThresholdItems = new String[]{"down", "critical", "major", "minor"};
    private String t3ManagementValue;
    private static String[] t3ManagementItems;
    private String t4ManagementValue;
    private static String[] t4ManagementItems;
    private String contactEmailValue;
    private String pollingIntervalValue;
    private String[] appTokens;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PrintWriter out;
    private AdminCommand adminCommand = null;
    private DiscoveryCommand discoveryCommand;
    private EmailCommand emailCommand;
    private SNMPCommand snmpCommand;
    private AlarmsCommand alarmsCommand;
    private LoggingCommand loggingCommand;
    private AttributeCommand attributeCommand;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (COLUMNS[0] == null) {
            Admin.COLUMNS[0] = new TableColumn(Localization.getString(BUNDLE, "app_table_title_name"), false, "\"left\"", true);
            Admin.COLUMNS[1] = new TableColumn(Localization.getString(BUNDLE, "app_table_title_url"), false, "\"left\"");
        }
    }

    public void destroy() {
    }

    protected void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        UtilsWeb.setContentType(httpServletRequest, httpServletResponse);
        this.out = httpServletResponse.getWriter();
        try {
            object = Security.getSecurity().getAuthorization(httpServletRequest, httpServletResponse, NSMPages.getPageURL(NSMPages.ADMIN_PAGE));
            if (object == null || !((String)object).equalsIgnoreCase("Admin")) {
                HTMLTags.addPendingMessage(httpServletRequest, "errorMessages", Localization.getString(BUNDLE, "not_authorized"));
                this.displayMasthead();
                return;
            }
        }
        catch (LoginException loginException) {
            return;
        }
        object = null;
        try {
            this.adminCommand = new AdminCommand();
            this.adminCommand.run();
            this.emailCommand = new EmailCommand();
            this.emailCommand.run();
            this.snmpCommand = new SNMPCommand();
            this.snmpCommand.run();
            this.alarmsCommand = new AlarmsCommand();
            this.alarmsCommand.run();
            this.loggingCommand = new LoggingCommand();
            this.loggingCommand.run();
            this.attributeCommand = new AttributeCommand();
            this.attributeCommand.run();
            this.discoveryCommand = new DiscoveryCommand();
            httpServletRequest.setAttribute("AdminId", (Object)this);
            this.getApplicationTokens();
            this.getT3ApplicationTokens();
            this.getT4ApplicationTokens();
            if (httpServletRequest.getParameter("submitcontrol") != null) {
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                String string6 = httpServletRequest.getParameter("email");
                if (string6 != null) {
                    this.setEmailOption(string6);
                }
                if ((string5 = httpServletRequest.getParameter("snmp")) != null) {
                    this.setSNMPOption(string5);
                }
                String string7 = httpServletRequest.getParameter("timetext");
                String string8 = httpServletRequest.getParameter("periodselect");
                if (string7 != null && string8 != null) {
                    if (string7.equals("")) {
                        string7 = "0";
                    }
                    boolean bl = true;
                    long l = 0L;
                    try {
                        l = Long.parseLong(Utils.getMinutesValue(string7, string8)) * 60L * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                        HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "admin_exp_time_number"));
                    }
                    if (l < 0L) {
                        bl = false;
                        HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "admin_exp_time_number"));
                    }
                    if (bl) {
                        this.alarmsCommand.setExpirationTime(l);
                    }
                }
                if ((string4 = httpServletRequest.getParameter("logthresholdselect")) != null) {
                    this.loggingCommand.setLoggingThreshold(Integer.parseInt(Utils.mapTokenToSeverity(string4)));
                }
                this.setApplicationsValues();
                String string9 = httpServletRequest.getParameter("t3managementselect");
                if (string9 != null) {
                    this.attributeCommand.setAttribute("t3management", string9);
                }
                if ((string3 = httpServletRequest.getParameter("t4managementselect")) != null) {
                    this.attributeCommand.setAttribute("t4management", string3);
                }
                if ((string2 = httpServletRequest.getParameter("contactemailtext")) != null) {
                    this.attributeCommand.setAttribute("contactemail", string2);
                }
                if ((string = httpServletRequest.getParameter("pollingintervaltext")) != null) {
                    int n = 1;
                    boolean bl = true;
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                        HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "admin_polling_int_number"));
                    }
                    if (n < 1 || 60000L * (long)n > Integer.MAX_VALUE) {
                        bl = false;
                        HTMLTags.addPendingMessage(httpServletRequest, "warningMessages", Localization.getString(BUNDLE, "admin_polling_int_number"));
                    }
                    if (bl) {
                        this.discoveryCommand.setRefreshInterval(n * 1000 * 60);
                    }
                }
            }
            this.setValues();
            this.buildTable();
        }
        catch (NSMUIException nSMUIException) {
            object = nSMUIException;
        }
        this.displayMasthead();
        if (object != null) {
            this.out.println(HTMLTags.getExceptionBoxTag(httpServletRequest, NSMPages.ADMIN_PAGE, (Throwable)object));
        } else {
            UtilsWeb.include(this.getServletContext(), "/jsp/admin.jsp", httpServletRequest, httpServletResponse);
        }
    }

    private void setValues() throws NSMUIException {
        this.emailPauseValue = this.emailCommand.isPaused() ? "off" : "on";
        this.snmpPauseValue = this.snmpCommand.isPaused() ? "off" : "on";
        long l = this.alarmsCommand.getExpirationTime() / 1000L / 60L;
        String[] stringArray = Utils.getTimeValue(String.valueOf(l));
        this.timeValue = stringArray[0];
        this.periodValue = stringArray[1];
        this.logThresholdValue = Utils.mapSeverityToToken(String.valueOf(this.loggingCommand.getLoggingThreshold()));
        this.t3ManagementValue = this.attributeCommand.getAttribute("t3management");
        if (this.t3ManagementValue == null || this.t3ManagementValue.equals("")) {
            this.t3ManagementValue = "sscs";
            this.attributeCommand.setAttribute("t3management", this.t3ManagementValue);
        }
        this.t4ManagementValue = this.attributeCommand.getAttribute("t4management");
        if (this.t4ManagementValue == null || this.t4ManagementValue.equals("")) {
            this.t4ManagementValue = "sscs";
            this.attributeCommand.setAttribute("t4management", this.t4ManagementValue);
        }
        this.contactEmailValue = this.attributeCommand.getAttribute("contactemail");
        this.pollingIntervalValue = String.valueOf(this.discoveryCommand.getRefreshInterval() / 1000L / 60L);
    }

    private void setEmailOption(String string) throws NSMUIException {
        this.emailPauseValue = string;
        this.emailCommand.pause(string.equals("off"));
    }

    private void setSNMPOption(String string) throws NSMUIException {
        this.snmpPauseValue = string;
        this.snmpCommand.pause(string.equals("off"));
    }

    public String isOptionChecked(String string, String string2) {
        if ("email".equalsIgnoreCase(string)) {
            return this.emailPauseValue.equalsIgnoreCase(string2) ? "checked" : "";
        }
        if ("snmp".equalsIgnoreCase(string)) {
            return this.snmpPauseValue.equalsIgnoreCase(string2) ? "checked" : "";
        }
        return "";
    }

    private void displayMasthead() throws ServletException, IOException {
        UtilsWeb.noCacheHeader(this.response);
        Masthead.getMasthead(this.getServletContext()).print("Administration", "Administration", "General", NSMPages.getPageHelp(NSMPages.ADMIN_PAGE), this.request, this.response);
        this.out.println(HTMLTags.getBreadCrumbTag(this.request, NSMPages.ADMIN_PAGE));
        this.out.println(HTMLTags.getPendingMessagesTag(this.request));
        this.out.flush();
    }

    /*
     * Unable to fully structure code
     */
    public void buildTable() throws NSMUIException {
        var1_1 = new StringBuffer();
        var2_2 = this.appTokens.length;
        var3_3 = new String[var2_2][2];
        var4_4 = 0;
        while (var4_4 < var2_2) {
            block6: {
                var5_5 = this.attributeCommand.getAttribute(this.appTokens[var4_4]);
                if (var5_5 != null) break block6;
                var5_5 = Localization.getString("com.sun.netstorage.mgmt.nsmui.admin.Localization", this.appTokens[var4_4] + ".defaultURL", Configuration.getProperty("REGISTRY_HOST"));
                if (var5_5 == null) ** GOTO lbl-1000
                if (!AdminCommand.checkURLConnection(var5_5)) lbl-1000:
                // 2 sources

                {
                    var5_5 = "";
                } else {
                    try {
                        this.attributeCommand.setAttribute(this.appTokens[var4_4], var5_5);
                    }
                    catch (Exception var6_6) {
                        var5_5 = "";
                    }
                }
            }
            var1_1.append(HTMLTags.getLabeledInputFieldTag(Localization.getString("com.sun.netstorage.mgmt.nsmui.admin.Localization", this.appTokens[var4_4] + ".name"), this.appTokens[var4_4] + "text", var5_5, 40, 300));
            if (var4_4 < var2_2 - 1) {
                var1_1.append("<tr>");
                var1_1.append("<td colspan=\"8\"><img border=\"0\" height=\"5\" src=\"/nsm/images/general/dot.gif\" width=\"1\"></td>");
                var1_1.append("</tr>");
            }
            ++var4_4;
        }
        this.theTable = var1_1.toString();
    }

    private void getApplicationTokens() {
        StringTokenizer stringTokenizer = new StringTokenizer(Localization.getString(BUNDLE, "configurable_applications"), " ");
        this.appTokens = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            this.appTokens[n] = (String)stringTokenizer.nextElement();
            ++n;
        }
    }

    private void getT3ApplicationTokens() {
        StringTokenizer stringTokenizer = new StringTokenizer(Localization.getString(BUNDLE, "t3_applications"), " ");
        t3ManagementItems = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            Admin.t3ManagementItems[n] = (String)stringTokenizer.nextElement();
            ++n;
        }
    }

    private void getT4ApplicationTokens() {
        StringTokenizer stringTokenizer = new StringTokenizer(Localization.getString(BUNDLE, "t4_applications"), " ");
        t4ManagementItems = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            Admin.t4ManagementItems[n] = (String)stringTokenizer.nextElement();
            ++n;
        }
    }

    private void setApplicationsValues() throws NSMUIException {
        int n = 0;
        while (n < this.appTokens.length) {
            String string;
            String string2 = this.request.getParameter(this.appTokens[n] + "text");
            this.attributeCommand.setAttribute(this.appTokens[n], string2);
            String string3 = Localization.getString(BUNDLE, this.appTokens[n] + ".isUnixApp");
            if ("true".equals(string3)) {
                if (!string2.equals("") && !new File(string2).exists()) {
                    string = Localization.getString(BUNDLE, "path_problem", string2);
                    HTMLTags.addPendingMessage(this.request, "warningMessages", string);
                }
            } else if (!string2.equals("")) {
                if (!AdminCommand.checkURLConnection(string2)) {
                    string = Localization.getString(BUNDLE, "connection_problem", string2);
                    HTMLTags.addPendingMessage(this.request, "warningMessages", string);
                }
            }
            ++n;
        }
    }

    public String getLabelTag(String string) {
        return HTMLTags.getCustomTag(BUNDLE, string);
    }

    public String getTimeField() {
        return HTMLTags.getInputFieldTag("timetext", this.timeValue, 5, 5);
    }

    public String getPeriodMenu() {
        return HTMLTags.getMenuTag(BUNDLE, "periodselect", periodItems, this.periodValue);
    }

    public String getLogThresholdMenu() {
        return HTMLTags.getMenuTag(BUNDLE, "logthresholdselect", logThresholdItems, this.logThresholdValue);
    }

    public String getT3ManagementMenu() {
        return HTMLTags.getMenuTag(BUNDLE, "t3managementselect", t3ManagementItems, this.t3ManagementValue);
    }

    public String getT4ManagementMenu() {
        return HTMLTags.getMenuTag(BUNDLE, "t4managementselect", t4ManagementItems, this.t4ManagementValue);
    }

    public String getApplicationTable() {
        return this.theTable;
    }

    public String getContactEmailField() {
        return HTMLTags.getInputFieldTag("contactemailtext", this.contactEmailValue, 30, 100);
    }

    public String getPollingIntervalField() {
        return HTMLTags.getInputFieldTag("pollingintervaltext", this.pollingIntervalValue, 5, 5);
    }

    public String getEmailLinkButton() {
        return HTMLTags.getLinkMiniButtonTag(NSMPages.getPageURL(NSMPages.ADMIN_EMAIL_PAGE), Localization.getString(BUNDLE, "email_link_button"));
    }

    public String getHealthLinkButton() {
        String string = Localization.getString(BUNDLE, "health_link_button");
        String string2 = null;
        try {
            AttributeCommand attributeCommand = new AttributeCommand();
            attributeCommand.run();
            string2 = attributeCommand.getAttribute("sade");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2 == null || string2.equals("") ? HTMLTags.getDisabledMiniButtonTag(string) : HTMLTags.getLinkTargetMiniButtonTag(string2 + Localization.getString("com.sun.netstorage.mgmt.nsmui.launch.Localization", "sadeNotificationJSP"), string, "sade");
    }

    public String getSNMPLinkButton() {
        return HTMLTags.getLinkMiniButtonTag(NSMPages.getPageURL(NSMPages.ADMIN_SNMP_PAGE), Localization.getString(BUNDLE, "snmp_link_button"));
    }

    public String getSaveButton() {
        return HTMLTags.getSubmitButtonTag("savebutton", Localization.getString(BUNDLE, "save_label"));
    }

    public String getCancelButton() {
        return HTMLTags.getCancelButtonTag();
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }
}

