/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.common.clip;

import com.sun.netstorage.mgmt.common.clip.CommandOption;
import java.util.StringTokenizer;

public final class StatementOption {
    private final CommandOption option;
    private final Object argument;

    public StatementOption(CommandOption commandOption, String string) {
        if (commandOption == null) {
            throw new IllegalArgumentException("option == null");
        }
        if (commandOption.isBooleanOption()) {
            throw new IllegalArgumentException("non boolean option expected");
        }
        if (string == null) {
            throw new IllegalArgumentException("argument == null");
        }
        this.option = commandOption;
        this.argument = string;
    }

    public StatementOption(CommandOption commandOption, boolean bl) {
        if (commandOption == null) {
            throw new IllegalArgumentException("option == null");
        }
        if (!commandOption.isBooleanOption()) {
            throw new IllegalArgumentException("boolean option expected");
        }
        this.option = commandOption;
        this.argument = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public CommandOption getOption() {
        return this.option;
    }

    public String getArgument() {
        return this.argument.toString();
    }

    public boolean getArgumentAsBoolean() {
        return this.argument instanceof Boolean && (Boolean)this.argument != false;
    }

    public String[] getArgumentAsCollection() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.argument.toString(), this.argument.toString().indexOf(44) != -1 ? "," : " ");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length && stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.option.getLongName() != null) {
            stringBuffer.append("--");
            if (this.option.isBooleanOption() && !this.getArgumentAsBoolean()) {
                stringBuffer.append("no-");
            }
            stringBuffer.append(this.option.getLongName());
        } else {
            stringBuffer.append("-");
            stringBuffer.append(this.option.getShortName());
        }
        if (!this.option.isBooleanOption()) {
            stringBuffer.append(" \"");
            stringBuffer.append(this.getArgument());
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }
}

