/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.common.clip;

import com.sun.netstorage.mgmt.common.clip.Command;
import com.sun.netstorage.mgmt.common.clip.CommandOption;
import com.sun.netstorage.mgmt.common.clip.Localization;
import java.io.PrintWriter;

public abstract class AbstractCommand
implements Command {
    private final String bundle;
    private final String key;
    private final CommandOption[] options;

    protected AbstractCommand(String string, String string2, CommandOption[] commandOptionArray) {
        if (string == null) {
            throw new IllegalArgumentException("bundle == null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("key == null");
        }
        if (commandOptionArray != null) {
            int n = 0;
            while (n < commandOptionArray.length) {
                if (commandOptionArray[n] == null) {
                    throw new IllegalArgumentException("options[" + n + "] == null");
                }
                ++n;
            }
        }
        this.bundle = string;
        this.key = string2;
        this.options = commandOptionArray != null ? commandOptionArray : new CommandOption[]{};
    }

    public String getName() {
        return Localization.getString(this.bundle, this.key + ".name");
    }

    public String getDescription() {
        return Localization.getString(this.bundle, this.key + ".description");
    }

    public CommandOption[] getOptions() {
        return this.options;
    }

    public void printHelp(PrintWriter printWriter) {
        String string = Localization.getString(this.bundle, this.key + ".help");
        if (string.trim().length() == 0) {
            printWriter.println(this.getDescription());
        } else {
            printWriter.println(string);
        }
    }
}

