/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.web.util;

import com.sun.jade.util.PropertiesPersistenceException;
import com.sun.jade.util.PropertiesPersister;
import com.sun.jade.util.log.Report;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public final class DomainInfo {
    private static final String PROXY_HOST = "proxyHost";
    private static final String PROXY_PORT = "proxyPort";
    private static final String PROXY_FILE = "Proxy.properties";
    public static final String domainDirName = "domainlist";
    public static final String proxyDirName = "domain";

    private DomainInfo() {
    }

    public static void deleteDomain(String string) {
        if ((string = string.trim()) != null) {
            String string2 = domainDirName + File.separator + string + ".properties";
            try {
                PropertiesPersister.deleteProperties(string2);
            }
            catch (PropertiesPersistenceException propertiesPersistenceException) {
                Report.error.log(propertiesPersistenceException, (Object)("Couldn't delete domain " + string));
            }
        }
    }

    public static boolean isDomainExisted(String string) {
        if (string == null) {
            return true;
        }
        Iterator iterator = DomainInfo.getAllDomainProperties();
        boolean bl = false;
        while (iterator.hasNext()) {
            String string2 = ((Properties)iterator.next()).getProperty("name");
            if (!string.equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static void addDomain(String string, String string2, String string3, String string4, String string5) {
        if ((string = string.trim()) != null) {
            String string6 = domainDirName + File.separator + string + ".properties";
            try {
                Properties properties = new Properties();
                properties.setProperty("name", string);
                properties.setProperty("server", string2);
                properties.setProperty("port", string3);
                properties.setProperty("login", string4);
                properties.setProperty("password", string5);
                PropertiesPersister.saveProperties(properties, string6);
            }
            catch (PropertiesPersistenceException propertiesPersistenceException) {
                Report.error.log(propertiesPersistenceException, (Object)("Couldn't add/edit domain " + string));
            }
        }
    }

    public static void setProxy(String string, String string2, String string3) {
        String string4 = proxyDirName + File.separator + PROXY_FILE;
        try {
            Properties properties = new Properties();
            properties.setProperty("useProxy", string);
            if (string.equals("yes")) {
                string2 = string2 != null ? string2.trim() : "";
                string3 = string3 != null ? string3.trim() : "";
                properties.setProperty("proxyServer", string2);
                properties.setProperty(PROXY_PORT, string3);
                System.getProperties().put(PROXY_HOST, string2);
                System.getProperties().put(PROXY_PORT, string3);
            } else {
                properties.setProperty("proxyServer", "");
                properties.setProperty(PROXY_PORT, "");
                System.getProperties().remove(PROXY_PORT);
                System.getProperties().remove(PROXY_HOST);
            }
            PropertiesPersister.saveProperties(properties, string4);
        }
        catch (PropertiesPersistenceException propertiesPersistenceException) {
            Report.error.log(propertiesPersistenceException, (Object)"Couldn't set proxy");
        }
    }

    public static Properties getProxyProperties() {
        String string = proxyDirName + File.separator + PROXY_FILE;
        try {
            return PropertiesPersister.restoreProperties(string);
        }
        catch (PropertiesPersistenceException propertiesPersistenceException) {
            Report.error.log(propertiesPersistenceException, (Object)"Couldn't load proxy");
            return null;
        }
    }

    public static Properties getDomainProperties(String string) {
        if (string == null) {
            return null;
        }
        try {
            return PropertiesPersister.restoreProperties(domainDirName + File.separator + string + ".properties");
        }
        catch (PropertiesPersistenceException propertiesPersistenceException) {
            Report.error.log(propertiesPersistenceException, (Object)("Couldn't load domain " + string));
            return null;
        }
    }

    public static Iterator getAllDomainProperties() {
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        String string = System.getProperty("storade.propsSaveDir") + File.separator + domainDirName;
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                int n2 = stringArray[n].indexOf(".properties");
                if (n2 > 0) {
                    String string2 = stringArray[n].substring(0, n2);
                    Properties properties = DomainInfo.getDomainProperties(string2);
                    arrayList.add(properties);
                }
                ++n;
            }
        }
        return arrayList.iterator();
    }
}

