/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.web.topology;

import com.sun.jade.apps.topology.NetworkGraph;
import com.sun.jade.apps.topology.TopologyService;
import com.sun.jade.apps.topology.graph.model.BasicGraph;
import com.sun.jade.apps.topology.graph.model.BasicNode;
import com.sun.jade.apps.topology.graph.model.Graph;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.logic.domain.DomainMF;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.ui.topology.InvalidTopologyNode;
import com.sun.jade.ui.topology.TopologyModel;
import com.sun.jade.ui.topology.TopologyModelEvent;
import com.sun.jade.ui.topology.TopologyModelListener;
import com.sun.jade.ui.topology.TopologyNode;
import com.sun.jade.ui.topology.tree.Tree;
import com.sun.jade.ui.util.Properties;
import com.sun.jade.util.OID;
import com.sun.jade.util.log.Report;
import com.sun.jade.web.util.Updateable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class TopologyBean
implements TopologyModelListener,
Updateable {
    private static final String domain = Properties.getDomain();
    private static final String eventTopicForAlarm = ".alert";
    private static Hashtable controllers = new Hashtable();
    private boolean updated = true;
    private TopologyModel model;
    private Locale locale;
    private long lastAccessed = 0L;
    private long lastUpdated = 0L;
    private int maxInactiveTime = Integer.MAX_VALUE;
    private DefaultMutableTreeNode root;
    private DefaultTreeModel treeModel;
    private boolean init = false;
    private static final String unknownType = "Unknown";

    private TopologyBean(String string, Locale locale) {
        this.locale = locale;
        this.init();
        this.connect();
    }

    private void init() {
        this.root = new DefaultMutableTreeNode(new TopologyNode(domain));
        this.treeModel = new DefaultTreeModel(this.root);
    }

    public static synchronized TopologyBean get(String string, Locale locale) {
        TopologyBean topologyBean = (TopologyBean)controllers.get(string);
        if (topologyBean != null) {
            return topologyBean;
        }
        TopologyBean topologyBean2 = new TopologyBean(string, locale);
        controllers.put(string, topologyBean2);
        return topologyBean2;
    }

    public static synchronized TopologyBean get(String string) {
        return TopologyBean.get(string, Locale.getDefault());
    }

    public synchronized DefaultMutableTreeNode getRoot() throws RemoteException {
        this.buildTree();
        return this.root;
    }

    public synchronized void notify(TopologyModelEvent topologyModelEvent) {
        this.init = false;
        this.init();
        this.buildTree();
        if (topologyModelEvent.getMode() == TopologyModelEvent.REMOVE_NODE || topologyModelEvent.getMode() != TopologyModelEvent.REMOVE_GRAPH) {
            // empty if block
        }
        this.lastUpdated = System.currentTimeMillis();
    }

    public synchronized TopologyNode getRootNode() {
        if (this.root.getUserObject() instanceof TopologyNode) {
            TopologyNode topologyNode = (TopologyNode)this.root.getUserObject();
            return topologyNode;
        }
        return null;
    }

    private DefaultMutableTreeNode getDefaultMutableTreeNode(String string, String string2) {
        Object object;
        if (string == null || string2 == null) {
            return null;
        }
        if (this.root.getUserObject() instanceof TopologyNode && string.equals(((TopologyNode)(object = (TopologyNode)this.root.getUserObject())).getClassName()) && string2.equals(((TopologyNode)object).getName())) {
            return this.root;
        }
        object = this.root.breadthFirstEnumeration();
        while (object.hasMoreElements()) {
            TopologyNode topologyNode;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object.nextElement();
            if (!(defaultMutableTreeNode.getUserObject() instanceof TopologyNode) || !string.equals((topologyNode = (TopologyNode)defaultMutableTreeNode.getUserObject()).getClassName()) || !string2.equals(topologyNode.getName())) continue;
            return defaultMutableTreeNode;
        }
        return null;
    }

    private DefaultMutableTreeNode getDefaultMutableTreeNode(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        OID oID = new OID(string);
        if (this.root.getUserObject() instanceof TopologyNode && oID.equals(((TopologyNode)(object = (TopologyNode)this.root.getUserObject())).getOID())) {
            return this.root;
        }
        object = this.root.breadthFirstEnumeration();
        while (object.hasMoreElements()) {
            TopologyNode topologyNode;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object.nextElement();
            if (!(defaultMutableTreeNode.getUserObject() instanceof TopologyNode) || !oID.equals((topologyNode = (TopologyNode)defaultMutableTreeNode.getUserObject()).getOID())) continue;
            return defaultMutableTreeNode;
        }
        return null;
    }

    public synchronized TopologyNode getNode(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getDefaultMutableTreeNode(string);
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof TopologyNode) {
            return (TopologyNode)defaultMutableTreeNode.getUserObject();
        }
        Report.error.log("Node not found: " + string);
        return null;
    }

    public TopologyNode getNode(String string, String string2) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getDefaultMutableTreeNode(string, string2);
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof TopologyNode) {
            return (TopologyNode)defaultMutableTreeNode.getUserObject();
        }
        return null;
    }

    private TopologyNode getNodeByFruName(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        if (defaultMutableTreeNode == null || string == null) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(58);
        if (n != -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1, string.length());
        }
        if (string2 == null || string3 == null) {
            return null;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            String string4;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!(defaultMutableTreeNode2.getUserObject() instanceof String) || !string2.equals(string4 = (String)defaultMutableTreeNode2.getUserObject())) continue;
            Enumeration<TreeNode> enumeration2 = defaultMutableTreeNode2.breadthFirstEnumeration();
            while (enumeration2.hasMoreElements()) {
                TopologyNode topologyNode;
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration2.nextElement();
                if (!(defaultMutableTreeNode3.getUserObject() instanceof TopologyNode) || (topologyNode = (TopologyNode)defaultMutableTreeNode3.getUserObject()).getMSE() == null || !topologyNode.getMSE().getKeyValue().equals(string3)) continue;
                return topologyNode;
            }
        }
        return null;
    }

    private static boolean areIPequals(String string, String string2) {
        String string3 = null;
        String string4 = null;
        try {
            string3 = InetAddress.getByName(string).getHostAddress();
            string4 = InetAddress.getByName(string2).getHostAddress();
            if (string3 != null && string4 != null) {
                return string3.equals(string4);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public synchronized MF getMFByIP(String string) {
        if (string == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Enumeration<TreeNode> enumeration = this.root.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            TopologyNode topologyNode;
            MF mF;
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!(defaultMutableTreeNode.getUserObject() instanceof TopologyNode) || (mF = (topologyNode = (TopologyNode)defaultMutableTreeNode.getUserObject()).getMF()) == null) continue;
            try {
                String string2 = mF.getProperties().getProperty("ip");
                if (string2 == null || !TopologyBean.areIPequals(string, string2)) continue;
                return mF;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    public synchronized TopologyNode getNodeByDeviceName(String string, String string2) {
        if (string == null) {
            return null;
        }
        TopologyNode topologyNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Enumeration<TreeNode> enumeration = this.root.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            TopologyNode topologyNode2;
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!(defaultMutableTreeNode.getUserObject() instanceof TopologyNode) || (topologyNode2 = (TopologyNode)defaultMutableTreeNode.getUserObject()).getMF() == null) continue;
            String string3 = null;
            try {
                string3 = topologyNode2.getMF().getName();
                if (!string.equalsIgnoreCase(string3)) continue;
                topologyNode = topologyNode2;
                break;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (string2 != null) {
            return this.getNodeByFruName(defaultMutableTreeNode, string2);
        }
        return topologyNode;
    }

    public TopologyNode getParent(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        DefaultMutableTreeNode defaultMutableTreeNode3 = this.getDefaultMutableTreeNode(string);
        if (defaultMutableTreeNode3 != null && (defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getParent()) != null && defaultMutableTreeNode2.getUserObject() instanceof String && (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()) != null && defaultMutableTreeNode.getUserObject() instanceof TopologyNode) {
            return (TopologyNode)defaultMutableTreeNode.getUserObject();
        }
        return null;
    }

    public synchronized Iterator getChildren(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getDefaultMutableTreeNode(string);
        if (defaultMutableTreeNode != null) {
            Vector<Object> vector = new Vector<Object>();
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = enumeration.nextElement();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode;
                if (defaultMutableTreeNode2.getUserObject() instanceof String) {
                    Enumeration<TreeNode> enumeration2 = defaultMutableTreeNode2.children();
                    while (enumeration2.hasMoreElements()) {
                        TreeNode treeNode2 = enumeration2.nextElement();
                        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)treeNode2;
                        if (!(defaultMutableTreeNode3.getUserObject() instanceof TopologyNode)) continue;
                        vector.add(defaultMutableTreeNode3.getUserObject());
                    }
                    continue;
                }
                if (!(defaultMutableTreeNode2.getUserObject() instanceof TopologyNode)) continue;
                vector.add(defaultMutableTreeNode2.getUserObject());
            }
            return vector.iterator();
        }
        return null;
    }

    private void connect() {
        if (this.locale == null) {
            throw new IllegalStateException();
        }
        try {
            this.model = TopologyModel.get(domain);
            this.model.addTopologyModelListener(this);
            this.buildTree();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getFrameName() {
        return "treeContentFrame";
    }

    public String getLocation() {
        return "treeContent.jsp";
    }

    public String getWindowName() {
        return "";
    }

    public boolean isUpdated() {
        if (!this.updated) {
            return false;
        }
        boolean bl = this.lastUpdated > this.lastAccessed;
        this.lastAccessed = System.currentTimeMillis();
        return bl;
    }

    public void setUpdated(boolean bl) {
        this.updated = bl;
    }

    public long getLastUpdatedTime() {
        return this.lastUpdated;
    }

    public int getMaxInactiveTime() {
        return this.maxInactiveTime;
    }

    public void setMaxInactiveTime(int n) {
        this.maxInactiveTime = n;
    }

    public void clear() {
    }

    /*
     * Unable to fully structure code
     */
    private void generateNodes(MF var1_1, DefaultMutableTreeNode var2_2, Iterator var3_3) throws InvalidTopologyNode {
        var4_4 = new HashMap<String, DefaultMutableTreeNode>();
        if (var3_3 != null) ** GOTO lbl17
        return;
lbl-1000:
        // 1 sources

        {
            var5_5 = (com.sun.jade.ui.topology.tree.TreeNode)var3_3.next();
            if (var5_5 == null || !((var6_6 = var5_5.getUserObject()) instanceof ReferenceForMSE)) continue;
            var7_7 = (ReferenceForMSE)var6_6;
            var8_8 = var7_7.getLocalizedCreationClassName();
            if (!var4_4.containsKey(var8_8)) {
                var9_9 = new DefaultMutableTreeNode(var8_8);
                this.treeModel.insertNodeInto(var9_9, var2_2, var2_2.getChildCount());
                var4_4.put(var8_8, var9_9);
            }
            var9_9 = new DefaultMutableTreeNode(new TopologyNode(var1_1, var7_7));
            var10_10 = (DefaultMutableTreeNode)var4_4.get(var8_8);
            this.treeModel.insertNodeInto(var9_9, var10_10, var10_10.getChildCount());
            this.populateBranchI(var1_1, var9_9, var5_5);
lbl17:
            // 3 sources

            ** while (var3_3.hasNext())
        }
lbl18:
        // 1 sources

    }

    private void populateBranch(MF mF, DefaultMutableTreeNode defaultMutableTreeNode, Tree tree) throws InvalidTopologyNode {
        if (tree != null) {
            Iterator iterator = tree.getRoots();
            this.generateNodes(mF, defaultMutableTreeNode, iterator);
        }
    }

    private void populateBranchI(MF mF, DefaultMutableTreeNode defaultMutableTreeNode, com.sun.jade.ui.topology.tree.TreeNode treeNode) throws InvalidTopologyNode {
        Iterator iterator = treeNode.getChildren();
        this.generateNodes(mF, defaultMutableTreeNode, iterator);
    }

    private synchronized void buildTree() {
        try {
            if (!this.init) {
                this.init = true;
                Graph graph = this.getGraph();
                if (graph == null) {
                    return;
                }
                this.build(graph);
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    private void updateRootNode(TopologyNode topologyNode, MF mF) {
        TopologyNode topologyNode2 = (TopologyNode)this.root.getUserObject();
        topologyNode2.setMF(mF);
        try {
            this.populateBranch(mF, this.root, topologyNode.getFRUs());
        }
        catch (InvalidTopologyNode invalidTopologyNode) {
            // empty catch block
        }
    }

    private void addNode(HashMap hashMap, TopologyNode topologyNode) {
        Object object;
        MF mF = topologyNode.getMF();
        String string = unknownType;
        try {
            object = mF.getCaption();
            if (object != null && object.getLocalizedMessage(this.locale) != null) {
                string = object.getLocalizedMessage(this.locale);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (!hashMap.containsKey(string)) {
            object = new DefaultMutableTreeNode(string);
            this.treeModel.insertNodeInto((MutableTreeNode)object, this.root, this.root.getChildCount());
            hashMap.put(string, object);
        }
        try {
            object = new DefaultMutableTreeNode(topologyNode);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)hashMap.get(string);
            this.treeModel.insertNodeInto((MutableTreeNode)object, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            this.populateBranch(mF, (DefaultMutableTreeNode)object, topologyNode.getFRUs());
        }
        catch (InvalidTopologyNode invalidTopologyNode) {
            // empty catch block
        }
    }

    private void build(Graph graph) {
        HashMap hashMap = new HashMap();
        Iterator iterator = graph.nodes();
        while (iterator.hasNext()) {
            BasicNode basicNode;
            Object object;
            Object e = iterator.next();
            if (!(e instanceof BasicNode) || !((object = (basicNode = (BasicNode)e).getUserObject()) instanceof TopologyNode)) continue;
            MF mF = ((TopologyNode)object).getMF();
            if (mF instanceof DomainMF) {
                this.updateRootNode((TopologyNode)object, mF);
                continue;
            }
            this.addNode(hashMap, (TopologyNode)object);
        }
    }

    public synchronized Graph getGraph() throws RemoteException {
        this.buildTree();
        TopologyService topologyService = this.model.getService();
        if (topologyService == null) {
            Report.error.log("null topology service. Possibly the topology service was not started");
            return null;
        }
        Graph graph = topologyService.getGraph();
        if (graph instanceof BasicGraph) {
            return (Graph)((BasicGraph)graph).clone();
        }
        return graph;
    }

    public synchronized NetworkGraph getNetworkGraph() throws RemoteException {
        return this.model.getService().getNetworkGraph();
    }

    public synchronized Vector getDeletedEdges() throws RemoteException {
        return this.model.getService().getDeletedEdges();
    }

    public synchronized boolean removeEdgesByUser(String[] stringArray, String string) throws RemoteException {
        return this.model.getService().deleteEdgesByUser(stringArray, string);
    }

    public synchronized boolean restoreEdgesByUser(String[] stringArray) throws RemoteException {
        return this.model.getService().undeleteEdgesByUser(stringArray);
    }

    public synchronized boolean purgeDeletedEdgesByUser(String[] stringArray) throws RemoteException {
        return this.model.getService().purgeDeletedEdgesByUser(stringArray);
    }
}

