/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.web.notification;

import com.sun.jade.event.Alarm;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.event.generator.EventHelper;
import com.sun.jade.ui.topology.TopologyNode;
import com.sun.jade.ui.util.DeviceHelper;
import com.sun.jade.ui.util.LocaleToCharsetMap;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class Event
implements Comparable {
    private DateFormat df1;
    private DateFormat df2;
    public static final int COMPARE_BY_DEVICE = 0;
    public static final int COMPARE_BY_DEVICE_TYPE = 1;
    public static final int COMPARE_BY_TOPIC = 2;
    public static final int COMPARE_BY_TIME = 3;
    public static final int COMPARE_BY_SEVERITY = 4;
    private int compareMode = 3;
    private boolean isAsc = false;
    private Locale locale;
    private long time;
    private int severity;
    private String device;
    private String deviceType;
    private String eventID;
    private String shortDescription;
    private String topicName;
    private boolean isAlarm = false;
    private boolean alarmIsCleared;
    private boolean alarmIsAck;
    private String pageContext;
    private long index;

    public Event(Locale locale, long l, NSMEvent nSMEvent, String string, String string2, String string3) {
        this.locale = locale;
        this.device = string;
        this.deviceType = string2;
        this.index = l;
        this.pageContext = string3;
        this.severity = nSMEvent.getSeverity();
        this.time = nSMEvent.getSubjectTime();
        this.eventID = nSMEvent.getEventID();
        this.topicName = EventHelper.getTopic(locale, nSMEvent.getTopic());
        if (this.topicName == null) {
            this.topicName = nSMEvent.getTopic();
        }
        this.shortDescription = EventHelper.getShortDescription(locale, nSMEvent);
        this.df1 = DateFormat.getDateInstance(3, locale);
        this.df2 = DateFormat.getTimeInstance(1, LocaleToCharsetMap.toSupportedLocale(locale));
    }

    public Event(Locale locale, long l, Alarm alarm, String string, String string2, String string3) {
        this(locale, l, alarm.getEvent(), string, string2, string3);
        this.isAlarm = true;
        this.alarmIsCleared = alarm.getIsCleared();
        this.alarmIsAck = alarm.getIsAcked();
    }

    public long getIndex() {
        return this.index;
    }

    public void setCompareMode(int n, boolean bl) {
        this.compareMode = n;
        this.isAsc = bl;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getShortDescriptionWithLinkForAlarm() {
        String string = "<a href='/jade/jsp/alarmDetails.jsp?id=" + URLEncoder.encode(this.getEventID()) + "&" + this.pageContext + "&pageContext=" + URLEncoder.encode(this.pageContext) + "'>" + this.getShortDescription() + "</a>";
        return string;
    }

    public String getShortDescriptionWithLinkForEvent() {
        String string = "<a href='/jade/jsp/eventDetails.jsp?id=" + URLEncoder.encode(this.getEventID()) + "&" + this.pageContext + "&pageContext=" + URLEncoder.encode(this.pageContext) + "'>" + this.getShortDescription() + "</a>";
        return string;
    }

    public String getEventID() {
        return this.eventID;
    }

    public String getDevice() {
        if (this.device == null) {
            return "&nbsp;";
        }
        TopologyNode topologyNode = DeviceHelper.getNodeFromString(this.device, true);
        if (topologyNode == null) {
            return this.device;
        }
        try {
            String string = topologyNode.getOID().toString();
            String string2 = topologyNode.getMF().getCaption().getLocalizedMessage(this.locale);
            String string3 = "<a href=\"asset.jsp?mode=Device&OID=" + string + "\">" + string2 + "</a>";
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.device;
        }
    }

    public String getDeviceType() {
        if (this.deviceType == null) {
            return "&nbsp;";
        }
        return this.deviceType;
    }

    public String getTopic() {
        return this.topicName;
    }

    public String getIsCleared() {
        if (this.isAlarm && this.alarmIsCleared) {
            return "Yes";
        }
        return "No";
    }

    public String getIsAcked() {
        if (this.isAlarm && this.alarmIsAck) {
            return "Yes";
        }
        return "No";
    }

    public String getClearIcon() {
        String string = "&nbsp;";
        string = this.alarmIsCleared ? "<img src=\"../images/alarmClosed.gif\" alt=\"cleared\" border=0>" : "<img src=\"../images/alarmOpen.gif\" alt=\"open\" border=0>";
        return string;
    }

    public String getDate() {
        Date date = new Date(this.time);
        return this.df1.format(date).toString() + " " + this.df2.format(date).toString();
    }

    public long getSourceTime() {
        return this.time;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getSeverityValue() {
        String string = EventHelper.getSeverityValue(this.severity, this.locale);
        if (string == null) {
            string = "&nbsp;";
        }
        return string;
    }

    public String getSeverityIcon() {
        String string = "&nbsp;";
        String string2 = "";
        if (this.isAlarm) {
            if (this.alarmIsAck) {
                if (this.severity == 0 || this.severity == 1 || this.severity == 2 || this.severity == 3) {
                    string = "<img src=\"../images/alarmSev4Ack.gif\" alt=\"" + this.getSeverityValue() + "\" border=0>";
                } else if (this.severity == 4) {
                    string = "<img src=\"../images/alarmSev3Ack.gif\" alt=\"" + this.getSeverityValue() + "\" border=0>";
                } else if (this.severity == 5) {
                    string = "<img src=\"../images/alarmSev2Ack.gif\" alt=\"" + this.getSeverityValue() + "\" border=0>";
                } else if (this.severity == 6) {
                    string = "<img src=\"../images/alarmSev1Ack.gif\" alt=\"" + this.getSeverityValue() + "\" border=0>";
                }
            } else if (this.severity == 0 || this.severity == 1 || this.severity == 2 || this.severity == 3) {
                string = "<img src=\"../images/alarmSev4.gif\" alt=\"" + this.getSeverityValue() + "\" border=0>";
            } else if (this.severity == 4) {
                string = "<img src=\"../images/alarmSev3.gif\" alt=\"" + this.getSeverityValue() + "\" border=0>";
            } else if (this.severity == 5) {
                string = "<img src=\"../images/alarmSev2.gif\" alt=\"" + this.getSeverityValue() + "\" border=0>";
            } else if (this.severity == 6) {
                string = "<img src=\"../images/alarmSev1.gif\" alt=\"" + this.getSeverityValue() + "\" border=0>";
            }
        } else if (this.severity == 0 || this.severity == 1 || this.severity == 2 || this.severity == 3) {
            string = "<img src=\"../images/alarmSev4.gif\" alt=\"" + this.getSeverityValue() + "\" border=0>";
        } else if (this.severity == 4) {
            string = "<img src=\"../images/alarmSev3.gif\" alt=\"" + this.getSeverityValue() + "\" border=0>";
        } else if (this.severity == 5) {
            string = "<img src=\"../images/alarmSev2.gif\" alt=\"" + this.getSeverityValue() + "\" border=0>";
        } else if (this.severity == 6) {
            string = "<img src=\"../images/alarmSev1.gif\" alt=\"" + this.getSeverityValue() + "\" border=0>";
        }
        return string;
    }

    public int compareTo(Object object) {
        Event event = (Event)object;
        int n = this.compareMode == 0 ? this.getDevice().compareTo(event.getDevice()) : (this.compareMode == 1 ? this.getDeviceType().compareTo(event.getDeviceType()) : (this.compareMode == 2 ? this.getTopic().compareTo(event.getTopic()) : (this.compareMode == 3 ? (this.time < event.time ? -1 : (this.time == event.time ? 0 : 1)) : (this.severity < event.severity ? -1 : (this.severity == event.severity ? 0 : 1)))));
        if (!this.isAsc) {
            n *= -1;
        }
        return n;
    }

    private static int getTopicLength(String string) {
        int n;
        String string2 = string;
        int n2 = 0;
        while ((n = string2.indexOf(46)) != -1) {
            ++n2;
            string2 = string2.substring(n + 1);
        }
        return n2;
    }
}

