/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.web.health;

import com.sun.jade.event.NSMEvent;
import com.sun.jade.event.generator.EventHelper;
import com.sun.jade.ui.alarm.AlarmSummaryBean;
import com.sun.jade.util.locale.Localizer;
import java.net.URLEncoder;
import java.util.Locale;

public class DeviceHealthBean {
    private String deviceType;
    private String name;
    private String OID;
    private String health;
    private AlarmSummaryBean alarmSummary;
    private String severity;
    private Locale locale;
    private String backGround;
    String resource = "com.sun.jade.ui.resources.Internal";
    Localizer localizer = new Localizer(this.resource);
    public static final String sccs_id = "@(#)DeviceHealthBean.java\t1.16 03/12/03 SMI";

    public DeviceHealthBean(Locale locale, AlarmSummaryBean alarmSummaryBean) {
        this.alarmSummary = alarmSummaryBean;
        this.locale = locale;
        this.localizer.setLocale(locale);
    }

    public void setDeviceType(String string) {
        this.deviceType = string;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getNameWithLink() {
        String string = "<a href='asset.jsp?mode=Device&OID=" + this.getEncodedOID() + "'>" + this.getName() + "</a>";
        return string;
    }

    public void setBackGround(String string) {
        this.backGround = string;
    }

    public void setOID(String string) {
        this.OID = string;
    }

    public String getOID() {
        return this.OID;
    }

    public String getEncodedOID() {
        return URLEncoder.encode(this.OID);
    }

    public String getLocalizedDeviceType() {
        return this.localizer.getString(this.deviceType);
    }

    public String getActionsWithLink() {
        String string = this.alarmSummary.getSeverestAlarm().getEvent().getSubject();
        String string2 = this.localizer.getString("diagnose");
        String string3 = "/jade/jsp/testList.jsp?mode=Device&OID=" + this.getEncodedOID();
        if (this.backGround != null) {
            string3 = string3 + "&backGround=" + URLEncoder.encode(this.backGround);
        }
        String string4 = "[<a href='" + string3 + "'>" + string2 + "</a>]\n";
        return string4;
    }

    public Integer getSeverity() {
        int n = this.alarmSummary.getSeverestAlarm().getEvent().getSeverity();
        return new Integer(n);
    }

    public String getOutstandingAlarm() {
        NSMEvent nSMEvent = this.alarmSummary.getSeverestAlarm().getEvent();
        String string = EventHelper.getShortDescription(this.locale, nSMEvent);
        String string2 = EventHelper.getSeverityIcon(nSMEvent.getSeverity(), string) + "&nbsp" + "<a href=\"alarmDetails.jsp?mode=Device&OID=" + this.getEncodedOID() + "&id=" + nSMEvent.getEventID() + "\">" + string + "</a>";
        return string2;
    }

    public String getOutStandingAlarmText() {
        NSMEvent nSMEvent = this.alarmSummary.getSeverestAlarm().getEvent();
        String string = EventHelper.getShortDescription(this.locale, nSMEvent);
        return string;
    }

    public String getAlarmNumberWithLink() {
        String string = "<a href='alarms.jsp?useEventState=no&mode=Device&OID=" + this.getEncodedOID() + "'>" + this.getAlarmNumber() + "</a>";
        return string;
    }

    public Integer getAlarmNumber() {
        return new Integer(this.alarmSummary.getNumber());
    }
}

