/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.web.diags;

import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.ui.diags.monitor.model.MonitorModel;
import com.sun.jade.ui.diags.monitor.model.TestEvent;
import com.sun.jade.ui.diags.monitor.model.TestListener;
import com.sun.jade.ui.util.Properties;
import com.sun.jade.web.diags.DiagnosticResultBean;
import com.sun.jade.web.diags.MonitorBean;
import com.sun.jade.web.util.StringFormat;
import com.sun.jade.web.util.Updateable;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.Locale;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class TestResultBean
implements HttpSessionBindingListener,
TestListener,
Updateable {
    static final String domain = Properties.getDomain();
    public static final String baseWindowName = "Diagnostic_";
    private int index = 0;
    private DiagnosticResult result;
    private String testUserName;
    private MonitorModel monitor;
    private long lastAccessed = 0L;
    private long lastUpdated = 0L;
    private int maxInactiveTime = 1800000;
    private boolean updated = true;
    private String userName;
    private String elementKey;
    private String windowName;
    private String pageName;
    private String frameName = "";
    private Locale locale;
    private DateFormat df;
    private MonitorBean monitorBean;

    public String getElementKey() {
        return this.elementKey;
    }

    public void setElementKey(String string) {
        this.elementKey = string;
    }

    public String getEncodedElementKey() {
        return StringFormat.toURLString(this.elementKey);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
        if (this.monitor != null) {
            this.monitor.removeTestEventListener(this);
        }
        try {
            this.monitor = MonitorModel.get(domain, string);
            this.monitor.addTestEventListener(this);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean isAbortable() {
        if (!this.userName.equals(this.testUserName)) {
            return false;
        }
        if (this.result != null) {
            if (this.result.getPercentCompleteValue() == 100) {
                return false;
            }
            if (TestState.STOPPED.equals(this.result.getTestState())) {
                return false;
            }
        }
        return true;
    }

    public void setInitialResult(DiagnosticResult diagnosticResult, String string) {
        this.result = diagnosticResult;
        this.testUserName = string;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.df = DateFormat.getDateTimeInstance(1, 1, locale);
    }

    private void updateResult(DiagnosticResult diagnosticResult, String string) {
        if (this.result.getElementKey().equals(diagnosticResult.getElementKey())) {
            this.lastUpdated = System.currentTimeMillis();
            this.result = diagnosticResult;
            this.testUserName = string;
        }
    }

    public void notify(TestEvent testEvent) {
        DiagnosticResult diagnosticResult = testEvent.getDiagnosticResult();
        String string = testEvent.getUserID();
        this.updateResult(diagnosticResult, string);
    }

    public void setMonitor(MonitorBean monitorBean) {
        this.monitorBean = monitorBean;
    }

    public DiagnosticResultBean getResult() {
        return this.monitorBean.getResultBean(this.result.getElementKey().toString());
    }

    public String[] getTestResults() {
        if (this.result != null) {
            return this.result.getTestResults();
        }
        return null;
    }

    public String[] getTestResultsAsHTML() {
        if (this.result != null) {
            String[] stringArray = this.result.getTestResults();
            String[] stringArray2 = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = StringFormat.replaceInString(stringArray[n], "\n", "<br>");
                ++n;
            }
            return stringArray2;
        }
        return null;
    }

    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
    }

    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (this.monitor != null) {
            this.monitor.removeTestEventListener(this);
        }
    }

    public String getFrameName() {
        return this.frameName;
    }

    public void setFrameName(String string) {
        this.frameName = string;
    }

    public void setWindowName(String string) {
        this.windowName = string;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public void setPageName(String string) {
        this.pageName = string;
    }

    public String getLocation() {
        ++this.index;
        return this.pageName + "?elementKey=" + this.elementKey + "&windowName=" + this.windowName + "&index=" + this.index;
    }

    public boolean isUpdated() {
        if (!this.updated) {
            return false;
        }
        boolean bl = this.lastUpdated > this.lastAccessed;
        this.lastAccessed = System.currentTimeMillis();
        return bl;
    }

    public void setUpdated(boolean bl) {
        this.updated = bl;
    }

    public void clear() {
    }

    public long getLastUpdatedTime() {
        return this.lastUpdated;
    }

    public int getMaxInactiveTime() {
        return this.maxInactiveTime;
    }

    public void setMaxInactiveTime(int n) {
        this.maxInactiveTime = n;
    }

    protected void finalize() throws Throwable {
    }

    private class Result {
        DiagnosticResult data;
        String userName;

        Result(DiagnosticResult diagnosticResult, String string) {
            this.data = diagnosticResult;
            this.userName = string;
        }
    }
}

