/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.web.diags;

import com.sun.jade.apps.diags.lib.DiagnosticTestInfo;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.ui.diags.TestServiceFinder;
import com.sun.jade.ui.diags.monitor.model.MonitorModel;
import com.sun.jade.ui.diags.monitor.model.TestEvent;
import com.sun.jade.ui.diags.monitor.model.TestListener;
import com.sun.jade.ui.util.Properties;
import com.sun.jade.web.diags.DiagnosticResultBean;
import com.sun.jade.web.util.Updateable;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class MonitorBean
implements HttpSessionBindingListener,
TestListener,
Updateable {
    public static final String ALL_MODE = "all";
    public static final String ARCHIVE_MODE = "archive";
    public static final String SINGLE_MODE = "single";
    static final String domain = Properties.getDomain();
    private Vector results = new Vector();
    private MonitorModel monitor;
    private long lastAccessed = 0L;
    private long lastUpdated = 0L;
    private int maxInactiveTime = 1800000;
    private String userName;
    private Locale locale;
    private String mode = "single";
    private boolean updated = true;

    public MonitorBean(String string, Locale locale) {
        this.userName = string;
        this.locale = locale;
        this.connect();
    }

    public String getUserName() {
        return this.userName;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void connect() {
        if (this.userName == null || this.locale == null) {
            throw new IllegalStateException();
        }
        if (this.monitor != null) {
            this.monitor.removeTestEventListener(this);
        }
        try {
            this.monitor = MonitorModel.get(domain, this.userName, this.locale);
            this.monitor.addTestEventListener(this);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String string) {
        if (string == null) {
            return;
        }
        if (this.mode.equals(SINGLE_MODE) && string.equals(ALL_MODE)) {
            try {
                TestServiceFinder.get(domain).openAllSessionsView(this.userName);
            }
            catch (RemoteException remoteException) {}
        } else if (this.mode.equals(ALL_MODE) && string.equals(SINGLE_MODE)) {
            try {
                TestServiceFinder.get(domain).closeAllSessionsView(this.userName);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mode = string;
    }

    public String getArchive() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Vector vector = TestServiceFinder.get(domain).viewSessionLog(this.userName);
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    String string = (String)vector.elementAt(n) + "<br>";
                    stringBuffer.append(string);
                    ++n;
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public DiagnosticResult getResult(String string) {
        int n = 0;
        while (n < this.results.size()) {
            DiagnosticResult diagnosticResult = ((Result)this.results.elementAt((int)n)).data;
            if (diagnosticResult.getElementKey().toString().equals(string)) {
                return diagnosticResult;
            }
            ++n;
        }
        return null;
    }

    public DiagnosticTestInfo getTestInfo(String string) {
        int n = 0;
        while (n < this.results.size()) {
            DiagnosticResult diagnosticResult = ((Result)this.results.elementAt((int)n)).data;
            if (diagnosticResult.getElementKey().toString().equals(string)) {
                return ((Result)this.results.elementAt((int)n)).testInfo;
            }
            ++n;
        }
        return null;
    }

    DiagnosticResultBean getResultBean(String string) {
        int n = 0;
        while (n < this.results.size()) {
            DiagnosticResult diagnosticResult = ((Result)this.results.elementAt((int)n)).data;
            if (diagnosticResult.getElementKey().toString().equals(string)) {
                String string2 = ((Result)this.results.elementAt((int)n)).userName;
                String string3 = ((Result)this.results.elementAt((int)n)).elementName;
                String string4 = ((Result)this.results.elementAt((int)n)).data.getDiagnosticName();
                DiagnosticResultBean diagnosticResultBean = new DiagnosticResultBean(string2, string3, string4, diagnosticResult, this.locale);
                if (diagnosticResult.getResultList() != null) {
                    Object[] objectArray;
                    Vector vector = diagnosticResult.getResultList();
                    Vector<DiagnosticResultBean> vector2 = new Vector<DiagnosticResultBean>();
                    int n2 = 0;
                    while (n < vector.size()) {
                        objectArray = (DiagnosticResult)vector.elementAt(n2);
                        String string5 = objectArray.getDiagnosticName();
                        DiagnosticResultBean diagnosticResultBean2 = new DiagnosticResultBean(string2, string3, string5, (DiagnosticResult)objectArray, this.locale);
                        vector2.add(diagnosticResultBean2);
                        ++n;
                    }
                    objectArray = new DiagnosticResultBean[vector2.size()];
                    vector2.copyInto(objectArray);
                    diagnosticResultBean.setResultList((DiagnosticResultBean[])objectArray);
                }
                return diagnosticResultBean;
            }
            ++n;
        }
        return null;
    }

    public String getTestUserName(String string) {
        int n = 0;
        while (n < this.results.size()) {
            DiagnosticResult diagnosticResult = ((Result)this.results.elementAt((int)n)).data;
            String string2 = ((Result)this.results.elementAt((int)n)).userName;
            if (diagnosticResult.getElementKey().toString().equals(string)) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    private void updateResult(DiagnosticResult diagnosticResult, DiagnosticTestInfo diagnosticTestInfo, String string, String string2) {
        boolean bl = false;
        int n = 0;
        while (n < this.results.size()) {
            Result result = (Result)this.results.elementAt(n);
            DiagnosticResult diagnosticResult2 = result.data;
            if (diagnosticResult2.getElementKey().equals(diagnosticResult.getElementKey())) {
                result.data = diagnosticResult;
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.results.add(new Result(diagnosticResult, diagnosticTestInfo, string, string2));
        }
    }

    public void notify(TestEvent testEvent) {
        this.lastUpdated = System.currentTimeMillis();
        DiagnosticResult diagnosticResult = testEvent.getDiagnosticResult();
        DiagnosticTestInfo diagnosticTestInfo = testEvent.getDiagnosticTestInfo();
        String string = testEvent.getUserID();
        String string2 = diagnosticResult.getMse().getName();
        this.updateResult(diagnosticResult, diagnosticTestInfo, string, string2);
    }

    public DiagnosticResultBean[] getResults() {
        return this.getResults(this.getUserName());
    }

    public DiagnosticResultBean[] getAllResults() {
        return this.getResults(null);
    }

    private DiagnosticResultBean[] getResults(String string) {
        Object object;
        Vector<DiagnosticResultBean> vector = new Vector<DiagnosticResultBean>();
        int n = 0;
        while (n < this.results.size()) {
            String string2 = "N/A";
            String string3 = "N/A";
            String string4 = "N/A";
            object = ((Result)this.results.elementAt((int)n)).data;
            String string5 = ((Result)this.results.elementAt((int)n)).userName;
            String string6 = ((Result)this.results.elementAt((int)n)).elementName;
            DiagnosticTestInfo diagnosticTestInfo = ((Result)this.results.elementAt((int)n)).testInfo;
            String string7 = diagnosticTestInfo.getTestName(this.locale);
            if (string == null || string.equals(string5)) {
                if (object.getTestStartTime() != null) {
                    string2 = new SimpleDateFormat("M/d/yy h:mm:ss a z").format(object.getTestStartTime().getCalendar().getTime());
                }
                if (object.getTestCompletionTime() != null) {
                    string3 = new SimpleDateFormat("M/d/yy h:mm:ss a z").format(object.getTestCompletionTime().getCalendar().getTime());
                }
                if (object.getTimeStamp() != null) {
                    string4 = new SimpleDateFormat("M/d/yy h:mm:ss a z").format(object.getTimeStamp().getCalendar().getTime());
                }
                String string8 = "N/A";
                if (((DiagnosticResult)object).getTestStateValueMap() != null) {
                    string8 = ((DiagnosticResult)object).getLocalizedTestState(this.locale);
                }
                String string9 = object.getPercentComplete() + "%";
                boolean bl = ((DiagnosticResult)object).getIsPackageValue();
                String string10 = ((DiagnosticResult)object).getElementKey().toString();
                DiagnosticResultBean diagnosticResultBean = new DiagnosticResultBean(string5, string6, string7, string2, string3, string4, string8, string9, bl, string10, this.locale);
                vector.add(diagnosticResultBean);
            }
            ++n;
        }
        object = new DiagnosticResultBean[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
    }

    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (this.monitor != null) {
            this.monitor.removeTestEventListener(this);
        }
    }

    public String getFrameName() {
        return "monitorFrame";
    }

    public String getLocation() {
        String string = "monitor.jsp";
        String string2 = this.getMode();
        if (string2 != null) {
            string = string + "?mode=" + string2;
        }
        return string;
    }

    public String getWindowName() {
        return "";
    }

    public boolean isUpdated() {
        if (!this.updated) {
            return false;
        }
        boolean bl = this.lastUpdated > this.lastAccessed;
        this.lastAccessed = System.currentTimeMillis();
        return bl;
    }

    public void setUpdated(boolean bl) {
        this.updated = bl;
    }

    public void clear() {
        this.results.clear();
    }

    public long getLastUpdatedTime() {
        return this.lastUpdated;
    }

    public int getMaxInactiveTime() {
        return this.maxInactiveTime;
    }

    public void setMaxInactiveTime(int n) {
        this.maxInactiveTime = n;
    }

    protected void finalize() throws Throwable {
    }

    private class Result {
        DiagnosticResult data;
        DiagnosticTestInfo testInfo;
        String userName;
        String elementName;

        Result(DiagnosticResult diagnosticResult, DiagnosticTestInfo diagnosticTestInfo, String string, String string2) {
            this.data = diagnosticResult;
            this.testInfo = diagnosticTestInfo;
            this.userName = string;
            this.elementName = string2;
        }
    }
}

