/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.web.diags;

import com.sun.jade.apps.diags.lib.DiagnosticTestInfo;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.mse.ElementKey;
import com.sun.jade.cim.util.ParameterType;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.ui.diags.TestServiceFinder;
import com.sun.jade.ui.diags.monitor.model.TestEvent;
import com.sun.jade.ui.topology.TopologyNode;
import com.sun.jade.ui.util.Converter;
import com.sun.jade.ui.util.InvalidDataException;
import com.sun.jade.ui.util.NotInRangeException;
import com.sun.jade.ui.util.Properties;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import com.sun.jade.web.diags.DiagnosticTestBean;
import com.sun.jade.web.diags.MonitorBean;
import com.sun.jade.web.topology.TopologyBean;
import com.sun.jade.web.util.StringFormat;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import com.sun.wbem.cim.UnsignedInt8;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class DiagnosticBean {
    private static final String resource = "com.sun.jade.ui.resources.Internal";
    static final String domain = Properties.getDomain();
    private Locale locale;
    private String oidName;

    public DiagnosticBean(String string) {
        this(string, Locale.getDefault());
    }

    public DiagnosticBean(String string, Locale locale) {
        this.oidName = string;
        this.locale = locale;
    }

    public String getOidName() {
        return this.oidName;
    }

    public void setOidName(String string) {
        this.oidName = string;
    }

    public DiagnosticTestBean[] getDiagnosticTests() throws RemoteException {
        if (this.oidName == null) {
            return null;
        }
        TopologyNode topologyNode = TopologyBean.get(domain).getNode(this.oidName);
        if (topologyNode == null || topologyNode.getDomain() != null) {
            return new DiagnosticTestBean[0];
        }
        DiagnosticTestInfo[] diagnosticTestInfoArray = topologyNode.getMSE() == null ? TestServiceFinder.get(domain).getTestsForMF(topologyNode.getMF()) : TestServiceFinder.get(domain).getMseTestsForMF(topologyNode.getMF(), topologyNode.getMSE());
        if (diagnosticTestInfoArray == null) {
            return new DiagnosticTestBean[0];
        }
        DiagnosticTestBean[] diagnosticTestBeanArray = new DiagnosticTestBean[diagnosticTestInfoArray.length];
        int n = 0;
        while (n < diagnosticTestInfoArray.length) {
            ReferenceForMSE referenceForMSE = new ReferenceForMSE(diagnosticTestInfoArray[n].getMSE());
            String string = referenceForMSE.getCreationClassName();
            String string2 = referenceForMSE.getKeyName();
            String string3 = referenceForMSE.getKeyValue();
            diagnosticTestBeanArray[n] = new DiagnosticTestBean(diagnosticTestInfoArray[n].getTestName(), diagnosticTestInfoArray[n].getTestName(this.locale), this.locale, this.oidName, string, string2, string3, diagnosticTestInfoArray[n].getTestCharacteristics());
            ++n;
        }
        return diagnosticTestBeanArray;
    }

    public DiagnosticTestInfo getDiagnosticTest(String string) throws RemoteException {
        TopologyNode topologyNode = TopologyBean.get(domain).getNode(this.oidName);
        if (topologyNode == null) {
            return null;
        }
        DiagnosticTestInfo[] diagnosticTestInfoArray = topologyNode.getMSE() == null ? TestServiceFinder.get(domain).getTestsForMF(topologyNode.getMF()) : TestServiceFinder.get(domain).getMseTestsForMF(topologyNode.getMF(), topologyNode.getMSE());
        if (diagnosticTestInfoArray != null) {
            int n = 0;
            while (n < diagnosticTestInfoArray.length) {
                ReferenceForMSE referenceForMSE = new ReferenceForMSE(diagnosticTestInfoArray[n].getMSE());
                if (diagnosticTestInfoArray[n].getTestName().equals(string)) {
                    return diagnosticTestInfoArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public DiagnosticTestInfo getDiagnosticTest(String string, String string2, String string3, String string4) throws RemoteException {
        TopologyNode topologyNode = TopologyBean.get(domain).getNode(this.oidName);
        if (topologyNode == null) {
            return null;
        }
        DiagnosticTestInfo[] diagnosticTestInfoArray = topologyNode.getMSE() == null ? TestServiceFinder.get(domain).getTestsForMF(topologyNode.getMF()) : TestServiceFinder.get(domain).getMseTestsForMF(topologyNode.getMF(), topologyNode.getMSE());
        if (diagnosticTestInfoArray != null) {
            int n = 0;
            while (n < diagnosticTestInfoArray.length) {
                ReferenceForMSE referenceForMSE = new ReferenceForMSE(diagnosticTestInfoArray[n].getMSE());
                String string5 = referenceForMSE.getCreationClassName();
                String string6 = referenceForMSE.getKeyName();
                String string7 = referenceForMSE.getKeyValue();
                if (diagnosticTestInfoArray[n].getTestName().equals(string) && string5.equals(string2) && string6.equals(string3) && string7.equals(string4)) {
                    return diagnosticTestInfoArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public DiagnosticTestBean getDiagnosticTestBean(String string, String string2, String string3, String string4) throws RemoteException {
        DiagnosticTestInfo diagnosticTestInfo = this.getDiagnosticTest(string, string2, string3, string4);
        ReferenceForMSE referenceForMSE = new ReferenceForMSE(diagnosticTestInfo.getMSE());
        String string5 = referenceForMSE.getCreationClassName();
        String string6 = referenceForMSE.getKeyName();
        String string7 = referenceForMSE.getKeyValue();
        DiagnosticTestBean diagnosticTestBean = new DiagnosticTestBean(diagnosticTestInfo.getTestName(), diagnosticTestInfo.getTestName(this.locale), this.locale, this.oidName, string5, string6, string7, diagnosticTestInfo.getTestCharacteristics());
        return diagnosticTestBean;
    }

    public static String buildField(TestParameter testParameter, Locale locale) {
        String string = testParameter.getDisplayName();
        Object object = testParameter.getDefaultValue();
        String string2 = "p_" + StringFormat.toURLString(testParameter.getName());
        StringBuffer stringBuffer = new StringBuffer();
        ParameterType parameterType = testParameter.getParameterType();
        if (object instanceof String && parameterType.equals(ParameterType.PASSWORD)) {
            stringBuffer.append("<input type=password name=" + string2 + " size=32 maxlength=80 ");
            stringBuffer.append("value= \"" + object + "\" >");
        } else if (object instanceof String) {
            if (testParameter.getValidValues() == null) {
                stringBuffer.append("<input type=text name=" + string2 + " size=32 maxlength=80 ");
                stringBuffer.append("value= \"" + object + "\" >");
            } else {
                stringBuffer.append("<select name=" + string2 + ">");
                Object[] objectArray = testParameter.getValidValues();
                stringBuffer.append("<option>" + object);
                int n = 0;
                while (n < objectArray.length) {
                    if (!objectArray[n].equals(object)) {
                        stringBuffer.append("<option>" + objectArray[n]);
                    }
                    ++n;
                }
                stringBuffer.append("</select>");
            }
        } else if (object instanceof Integer) {
            String string3 = object.toString();
            if (testParameter.getParameterType().equals(ParameterType.HEX_NUMBER)) {
                string3 = Integer.toHexString((Integer)object);
            } else if (testParameter.getParameterType().equals(ParameterType.OCTAL_NUMBER)) {
                string3 = Integer.toOctalString((Integer)object);
            }
            stringBuffer.append("<input type=text name=" + string2 + " size=32 maxlength=80 ");
            stringBuffer.append("value= \"" + string3 + "\" >");
        } else if (object instanceof Float) {
            stringBuffer.append("<input type=text name=" + string2 + " size=32 maxlength=80 ");
            stringBuffer.append("value= \"" + object + "\" >");
        } else if (object instanceof UnsignedInt8) {
            stringBuffer.append("<input type=text name=" + string2 + " size=32 maxlength=80 ");
            stringBuffer.append("value= \"" + object + "\" >");
        } else if (object instanceof UnsignedInt16) {
            stringBuffer.append("<input type=text name=" + string2 + " size=32 maxlength=80 ");
            stringBuffer.append("value= \"" + object + "\" >");
        } else if (object instanceof UnsignedInt32) {
            stringBuffer.append("<input type=text name=" + string2 + " size=32 maxlength=80 ");
            stringBuffer.append("value= \"" + object + "\" >");
        } else if (object instanceof UnsignedInt64) {
            stringBuffer.append("<input type=text name=" + string2 + " size=32 maxlength=80 ");
            stringBuffer.append("value= \"" + object + "\" >");
        } else if (object instanceof Boolean) {
            stringBuffer.append("<select name=" + string2 + ">");
            Localizer localizer = new Localizer(resource);
            if (locale != null) {
                localizer.setLocale(locale);
            }
            stringBuffer.append("<option value=" + object.toString() + ">" + localizer.getString(object.toString()));
            if (((Boolean)object).equals(Boolean.TRUE)) {
                stringBuffer.append("<option value=" + Boolean.FALSE + ">" + localizer.getString(Boolean.FALSE.toString()));
            } else {
                stringBuffer.append("<option value=" + Boolean.TRUE + ">" + localizer.getString(Boolean.TRUE.toString()));
            }
            stringBuffer.append("</select>");
        } else {
            stringBuffer.append("<input type=text name=" + string2 + " size=32 maxlength=80 ");
            stringBuffer.append("value= \"" + object + "\" >");
        }
        return stringBuffer.toString();
    }

    private static String getValue(String string, ServletRequest servletRequest) {
        String string2 = servletRequest.getParameter("charset");
        Enumeration enumeration = servletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = string3;
            if (!string4.startsWith("p_") || !(string4 = string4.substring(2)).equals(string)) continue;
            String string5 = servletRequest.getParameter(string3);
            if (string2 != null) {
                try {
                    string5 = new String(string5.getBytes("8859_1"), string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Report.error.log(unsupportedEncodingException, (Object)("Unspported encoding: " + string2));
                }
            }
            return string5;
        }
        return null;
    }

    public ElementKey submitTest(ServletRequest servletRequest, String string) throws InvalidDataException, RemoteException {
        String string2 = servletRequest.getParameter("testName");
        String string3 = servletRequest.getParameter("creationClassName");
        String string4 = servletRequest.getParameter("keyName");
        String string5 = servletRequest.getParameter("keyValue");
        Vector<String> vector = new Vector<String>();
        if (this.oidName != null & string2 != null) {
            Object object;
            Object object2;
            Object object3;
            DiagnosticTestInfo diagnosticTestInfo = string3 == null || string4 == null || string5 == null ? this.getDiagnosticTest(string2) : this.getDiagnosticTest(string2, string3, string4, string5);
            if (diagnosticTestInfo == null) {
                return null;
            }
            DiagnosticSetting diagnosticSetting = diagnosticTestInfo.getSettingsForTest(this.locale);
            Vector vector2 = diagnosticSetting.getTestParameters();
            int n = 0;
            while (n < vector2.size()) {
                object3 = (TestParameter)vector2.get(n);
                object2 = DiagnosticBean.getValue(((TestParameter)object3).getName(), servletRequest);
                if (object2 != null) {
                    try {
                        object = Converter.getValue((TestParameter)object3, (String)object2);
                        ((TestParameter)object3).setCurrentValue(object);
                    }
                    catch (NotInRangeException notInRangeException) {
                        vector.add("error: " + ((TestParameter)object3).getDisplayName() + " not in range" + notInRangeException.getMin() + " " + notInRangeException.getMax());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ++n;
            }
            if (vector.size() > 0) {
                throw new InvalidDataException(vector);
            }
            object3 = TopologyBean.get(domain).getNode(this.oidName).getMF();
            object2 = TestServiceFinder.get(domain).submitTest(string, diagnosticTestInfo, (MF)object3);
            object = ((HttpServletRequest)servletRequest).getSession();
            MonitorBean monitorBean = (MonitorBean)object.getAttribute("monitorBean");
            DiagnosticResult diagnosticResult = new DiagnosticResult("", diagnosticTestInfo.getTestName());
            diagnosticResult.setElementKey((ElementKey)object2);
            diagnosticResult.setTestState(0);
            diagnosticResult.setPercentComplete((short)0);
            diagnosticResult.setMse(new ReferenceForMSE(diagnosticTestInfo.getMSE()));
            TestEvent testEvent = new TestEvent(null, diagnosticTestInfo, string, diagnosticResult, 0);
            if (monitorBean != null) {
                monitorBean.notify(testEvent);
            }
            return object2;
        }
        throw new InvalidDataException(vector);
    }
}

