/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.web.debug;

import com.sun.jade.apps.command.DebugCommand;
import com.sun.jade.util.log.Report;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class DebugServlet
extends HttpServlet {
    private static final String root = "/jade/debug/";
    private HashMap runList;
    public static final String sccs_id = "@(#)DebugServlet.java\t1.4 11/15/02 SMI";

    public void doRequest(String string, String string2, PrintWriter printWriter) throws IOException {
        this.initCmds();
        printWriter.println("<HTML><HEAD><TITLE>Debug Response</TITLE></HEAD><BODY><PRE>");
        if (!string.startsWith(root)) {
            this.showCommands(printWriter);
        } else {
            Object object;
            String string3 = string.substring(root.length());
            Properties properties = new Properties();
            if (string2 != null) {
                object = new StringTokenizer(string2, "&");
                while (((StringTokenizer)object).hasMoreElements()) {
                    String string4 = ((StringTokenizer)object).nextToken();
                    int n = string4.indexOf(61);
                    if (n <= 0) continue;
                    properties.setProperty(string4.substring(0, n), string4.substring(n + 1));
                }
            }
            if ((object = (DebugCommand)this.runList.get(string3)) == null) {
                this.showCommands(printWriter);
            } else {
                try {
                    object.execute(properties, printWriter);
                }
                catch (Throwable throwable) {
                    printWriter.println("<H1>Error running command.</H1>");
                    throwable.printStackTrace(printWriter);
                }
            }
        }
        printWriter.println("</PRE></BODY></HTML>");
        printWriter.close();
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setContentType("text/html");
        BufferedReader bufferedReader = httpServletRequest.getReader();
        PrintWriter printWriter = httpServletResponse.getWriter();
        String string = httpServletRequest.getRequestURI();
        String string2 = httpServletRequest.getQueryString();
        this.doRequest(string, string2, printWriter);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
    }

    private void showCommands(PrintWriter printWriter) {
        Set set = this.runList.keySet();
        Iterator iterator = set.iterator();
        printWriter.println("<H1>Internal Debug Interface</H1>");
        printWriter.println("Running of these internal debugging commands is not supported in any way.  Use at your own risk.");
        printWriter.println("Commands:<UL>");
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            DebugCommand debugCommand = (DebugCommand)this.runList.get(string);
            printWriter.print("<LI>");
            printWriter.print("<A HREF=\"/jade/debug/" + string);
            printWriter.print("\">");
            printWriter.print(string);
            printWriter.print("</A> ");
            printWriter.println(debugCommand.getHelp());
        }
        printWriter.println("</UL>");
    }

    private void initCmds() {
        if (this.runList != null) {
            return;
        }
        this.runList = new HashMap();
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle("com.sun.jade.web.debug.DebugServlet");
        }
        catch (MissingResourceException missingResourceException) {
            Report.error.log(missingResourceException, (Object)"DebugServlet not loaded.");
        }
        if (resourceBundle == null) {
            return;
        }
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = resourceBundle.getString(string);
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string2);
                this.runList.put(string, clazz.newInstance());
            }
            catch (Exception exception) {
                Report.warning.log(exception, (Object)("Debug command not loaded. " + string));
            }
        }
    }
}

