/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.util.unittest;

import com.sun.jade.util.unittest.UnitTestError;

public class UnitTest {
    private static final String sccs_id = "@(#)UnitTest.java\t1.4 04/04/02 SMI";

    public void assertCondition(boolean bl) {
        if (!bl) {
            this.fail();
        }
    }

    public void assertCondition(String string, boolean bl) {
        if (!bl) {
            this.fail(string);
        }
    }

    public void assertEquals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return;
        }
        if (object != null && object.equals(object2)) {
            return;
        }
        this.fail("expected:<" + object + "> but was :<" + object2 + ">");
    }

    public void assertNotEquals(Object object, Object object2) {
        if (object == null && object2 == null) {
            this.fail("both objects null in assertNotEquals");
        }
        if (object != null && object.equals(object2)) {
            this.fail("expected:<" + object + "> equals :<" + object2 + ">");
        }
    }

    public void assertNotNull(Object object) {
        this.assertCondition(object != null);
    }

    public void assertNull(Object object) {
        this.assertCondition(object == null);
    }

    public void fail() {
        this.fail("FAILURE");
    }

    public void fail(String string) {
        throw new UnitTestError(string);
    }

    protected void init() {
    }

    protected void cleanup() {
    }

    public static class Test
    extends UnitTest {
        public void testFail() {
            try {
                super.fail();
            }
            catch (UnitTestError unitTestError) {
                return;
            }
            System.err.println("fail() didn't fail");
            throw new Error("fail() didn't fail");
        }

        public void testAssert() {
            super.assertCondition("assert(true) failed", true);
            try {
                super.assertCondition(false);
            }
            catch (UnitTestError unitTestError) {
                return;
            }
            System.err.println("assertCondition(false) didn't fail");
            throw new Error("assertCondition(false) didn't fail");
        }

        public void testAssertEquals() {
            String string = "a";
            String string2 = "a";
            super.assertEquals(null, null);
            super.assertEquals(string, string2);
            super.assertEquals(string, string);
            try {
                super.assertEquals(null, string);
            }
            catch (UnitTestError unitTestError) {
                try {
                    super.assertEquals(string, null);
                }
                catch (UnitTestError unitTestError2) {
                    try {
                        string2 = "b";
                        super.assertEquals(string, string2);
                    }
                    catch (UnitTestError unitTestError3) {
                        return;
                    }
                }
            }
            throw new Error("assertEquals() didn't fail");
        }

        public void testAssertNull() {
            super.assertNotNull(new Object());
            super.assertNull(null);
        }

        public void testNoOpTest() {
        }
    }
}

