/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.ui.util;

import com.sun.jade.ui.util.Help;
import java.io.FileReader;
import java.util.ArrayList;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class HelpParser {
    private static String PAGE = "page";
    private static String NAME = "name";
    private static String URL = "url";
    private static String TOC = "toc";
    private static String HELP_URL = "helpUrl";
    private static String AMP = "amp";
    private static String LT = "lt";
    private static String GT = "gt";
    private static String QUOT = "\"";

    private String getText(Node node) {
        NodeList nodeList = node.getChildNodes();
        String string = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            switch (node2.getNodeType()) {
                case 1: {
                    break;
                }
                case 3: {
                    if (string == null) {
                        string = node2.getNodeValue().trim();
                        break;
                    }
                    string = string + node2.getNodeValue().trim();
                }
                case 4: {
                    break;
                }
                case 2: {
                    break;
                }
                case 5: {
                    if (AMP.equals(node2.getNodeName())) {
                        string = string + '&';
                        break;
                    }
                    if (LT.equals(node2.getNodeName())) {
                        string = string + '<';
                        break;
                    }
                    if (GT.equals(node2.getNodeName())) {
                        string = string + '>';
                        break;
                    }
                    if (!QUOT.equals(node2.getNodeName())) break;
                    string = string + '\"';
                }
            }
            ++n;
        }
        return string;
    }

    private Help parseHelp(Node node) {
        Help help = new Help();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            switch (node2.getNodeType()) {
                case 1: {
                    String string = node2.getNodeName();
                    if (NAME.equalsIgnoreCase(string)) {
                        help.name = this.getText(node2);
                        break;
                    }
                    if (URL.equalsIgnoreCase(string)) {
                        help.url = this.getText(node2);
                        break;
                    }
                    if (TOC.equalsIgnoreCase(string)) {
                        help.toc = this.getText(node2);
                        break;
                    }
                    if (!HELP_URL.equalsIgnoreCase(string)) break;
                    help.helpUrl = this.getText(node2);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            ++n;
        }
        return help;
    }

    public ArrayList parse(String string) throws Exception {
        ArrayList<Help> arrayList = new ArrayList<Help>();
        XmlDocument xmlDocument = XmlDocument.createXmlDocument((InputSource)new InputSource(new FileReader(string)), (boolean)false);
        Element element = xmlDocument.getDocumentElement();
        if ("pages".equalsIgnoreCase(element.getNodeName())) {
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (PAGE.equalsIgnoreCase(node.getNodeName())) {
                    Help help = this.parseHelp(node);
                    arrayList.add(help);
                }
                ++n;
            }
        }
        return arrayList;
    }

    public static void main(String[] stringArray) throws Exception {
        HelpParser helpParser = new HelpParser();
        ArrayList arrayList = helpParser.parse("help.xml");
        int n = 0;
        while (n < arrayList.size()) {
            Help help = (Help)arrayList.get(n);
            System.out.println("HELP NAME:      " + help.name);
            System.out.println("HELP URL:       " + help.url);
            System.out.println("HELP TOC:       " + help.toc);
            System.out.println("HELP HELP_URL:  " + help.helpUrl);
            ++n;
        }
    }
}

