/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.ui.util;

import com.sun.jade.ui.util.App;
import com.sun.jade.ui.util.Task;
import java.io.FileReader;
import java.util.ArrayList;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ApplicationsParser {
    private static String APP = "app";
    private static String NAME = "name";
    private static String TASK = "task";
    private static String URL = "url";
    private static String USECONTEXT = "useContext";
    private static String AMP = "amp";
    private static String LT = "lt";
    private static String GT = "gt";
    private static String QUOT = "\"";

    private String getText(Node node) {
        NodeList nodeList = node.getChildNodes();
        String string = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            switch (node2.getNodeType()) {
                case 1: {
                    break;
                }
                case 3: {
                    if (string == null) {
                        string = node2.getNodeValue().trim();
                        break;
                    }
                    string = string + node2.getNodeValue().trim();
                }
                case 4: {
                    break;
                }
                case 2: {
                    break;
                }
                case 5: {
                    if (AMP.equals(node2.getNodeName())) {
                        string = string + '&';
                        break;
                    }
                    if (LT.equals(node2.getNodeName())) {
                        string = string + '<';
                        break;
                    }
                    if (GT.equals(node2.getNodeName())) {
                        string = string + '>';
                        break;
                    }
                    if (!QUOT.equals(node2.getNodeName())) break;
                    string = string + '\"';
                }
            }
            ++n;
        }
        return string;
    }

    private Task parseTask(Node node) {
        Task task = new Task();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            switch (node2.getNodeType()) {
                case 1: {
                    String string = node2.getNodeName().trim();
                    if (NAME.equalsIgnoreCase(string)) {
                        task.name = this.getText(node2);
                        break;
                    }
                    if (URL.equalsIgnoreCase(string)) {
                        task.url = this.getText(node2);
                        break;
                    }
                    if (!USECONTEXT.equalsIgnoreCase(string)) break;
                    task.useContext = this.getText(node2);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            ++n;
        }
        return task;
    }

    private App parseApp(Node node) {
        App app = new App();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            switch (node2.getNodeType()) {
                case 1: {
                    String string = node2.getNodeName();
                    if (NAME.equalsIgnoreCase(string)) {
                        app.name = this.getText(node2);
                        break;
                    }
                    if (TASK.equalsIgnoreCase(string)) {
                        Task task = this.parseTask(node2);
                        app.tasks.add(task);
                        break;
                    }
                    if (URL.equalsIgnoreCase(string)) {
                        app.url = this.getText(node2);
                        break;
                    }
                    if (!USECONTEXT.equalsIgnoreCase(string)) break;
                    app.useContext = this.getText(node2);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            ++n;
        }
        return app;
    }

    public ArrayList parse(String string) throws Exception {
        ArrayList<App> arrayList = new ArrayList<App>();
        XmlDocument xmlDocument = XmlDocument.createXmlDocument((InputSource)new InputSource(new FileReader(string)), (boolean)false);
        Element element = xmlDocument.getDocumentElement();
        if ("applications".equalsIgnoreCase(element.getNodeName())) {
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (APP.equalsIgnoreCase(node.getNodeName())) {
                    App app = this.parseApp(node);
                    arrayList.add(app);
                }
                ++n;
            }
        }
        return arrayList;
    }

    public static void main(String[] stringArray) throws Exception {
        ApplicationsParser applicationsParser = new ApplicationsParser();
        ArrayList arrayList = applicationsParser.parse("applications.xml");
        int n = 0;
        while (n < arrayList.size()) {
            App app = (App)arrayList.get(n);
            System.out.println("APP NAME: " + app.name);
            System.out.println("APP URL:  " + app.url);
            int n2 = 0;
            while (n2 < app.tasks.size()) {
                Task task = (Task)app.tasks.get(n2);
                System.out.println("  TASK NAME: " + task.name);
                System.out.println("  TASK URL:  " + task.url);
                ++n2;
            }
            ++n;
        }
    }
}

