/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.ui.topology;

import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.device.util.DevInfo;
import com.sun.jade.event.Alarm;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.ui.alarm.AlarmSummaryBean;
import com.sun.jade.ui.topology.tree.Tree;
import com.sun.jade.util.OID;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;

public class TopologyNode {
    public static final int ACTIVE = 0;
    public static final int DEGRADED = 1;
    private MF mf;
    private ReferenceForMSE mse;
    private String className;
    private String displayName;
    private String elementClassName;
    private String elementKeyName;
    private String elementKeyValue;
    private String domain;
    private String[] zones;
    private int state;
    private OID oid;
    private Tree frus;
    private String numbrAlarm;
    private NSMEvent event;

    public TopologyNode(MF mF) {
        this(mF, (String)null, (String)null);
    }

    public TopologyNode(MF mF, String string) {
        String string2 = null;
        try {
            string2 = mF.getCaption().getLocalizedMessage(Locale.ENGLISH);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init(mF, string, string2);
    }

    public TopologyNode(MF mF, String string, String string2) {
        this.init(mF, string, string2);
    }

    private void init(MF mF, String string, String string2) {
        this.mf = mF;
        this.displayName = string2;
        try {
            this.className = mF.getClassName();
            this.oid = string == null || "".equals(string.trim()) ? new OID(TopologyNode.getType(this.className) + ":" + OID.getKey()) : new OID(TopologyNode.getType(this.className) + ":" + string);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public TopologyNode(MF mF, String string, Tree tree) {
        this(mF, string);
        this.frus = tree;
    }

    public TopologyNode(MF mF, String string, Tree tree, String[] stringArray) {
        this(mF, string, tree);
        this.zones = stringArray;
    }

    public TopologyNode(MF mF, ReferenceForMSE referenceForMSE) {
        this(mF);
        this.mse = referenceForMSE;
        this.elementClassName = referenceForMSE.getCreationClassName();
        this.elementKeyName = referenceForMSE.getKeyName();
        this.elementKeyValue = referenceForMSE.getKeyValue();
        this.oid = new OID(this.getName());
        this.displayName = this.getName();
    }

    public TopologyNode(String string) {
        this.oid = new OID();
        this.domain = string;
        this.displayName = this.getName();
    }

    public static String getType(String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = DevInfo.getAllDeviceProperties();
        while (iterator.hasNext()) {
            Properties properties = (Properties)iterator.next();
            String string2 = properties.getProperty("TYPE");
            String string3 = properties.getProperty("CLASS_NAME");
            if (!string.equals(string3)) continue;
            return string2;
        }
        return null;
    }

    public static String getCategory(String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = DevInfo.getAllDeviceProperties();
        while (iterator.hasNext()) {
            Properties properties = (Properties)iterator.next();
            String string2 = properties.getProperty("CATEGORY");
            String string3 = properties.getProperty("CLASS_NAME");
            if (!string.equals(string3)) continue;
            return string2;
        }
        return null;
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        if (this.domain != null) {
            return this.domain;
        }
        String string = null;
        try {
            string = this.mf.getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null || "".equals(string.trim())) {
            string = "Unknown";
        }
        if (this.mse != null) {
            string = string + " - " + this.mse.getCreationClassName() + ":" + this.mse.getKeyValue();
        }
        return string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getElementClassName() {
        return this.elementClassName;
    }

    public String getElementKeyName() {
        return this.elementKeyName;
    }

    public String getElementKeyValue() {
        return this.elementKeyValue;
    }

    public OID getOID() {
        return this.oid;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
    }

    public MF getMF() {
        return this.mf;
    }

    public void setMF(MF mF) {
        this.mf = mF;
    }

    public ReferenceForMSE getMSE() {
        return this.mse;
    }

    public Tree getFRUs() {
        return this.frus;
    }

    public void setFRUs(Tree tree) {
        this.frus = tree;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setNumbrAlarm(String string) {
        this.numbrAlarm = string;
    }

    public String getNumbrAlarm() {
        return this.numbrAlarm;
    }

    public void setEvent(NSMEvent nSMEvent) {
        this.event = nSMEvent;
    }

    public NSMEvent getEvent() {
        return this.event;
    }

    public void setZones(String[] stringArray) {
        this.zones = stringArray;
    }

    public String[] getZones() {
        return this.zones;
    }

    public AlarmSummaryBean getAlarmSummary(Locale locale) {
        Object object;
        Object object2;
        String string = "com.sun.jade.ui.resources.ApplicationResources";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("M/d/yyy h:mm:ss a z");
        Localizer localizer = new Localizer(string);
        if (locale != null) {
            localizer.setLocale(locale);
        }
        int n = 0;
        Object object3 = null;
        try {
            object2 = PersistenceService.getService();
            object = object2.getEventsPersistence();
            if (this.mf != null && this.mse == null) {
                n = object.retrieveNbrEventsBySystemName(this.mf.getClassName(), this.mf.getName(), 2, 2, 3);
                object3 = object.retrieveSeverestEventBySystemName(this.mf.getClassName(), this.mf.getName(), 2, 2, 3);
            } else if (this.mf != null && this.mse != null) {
                n = object.retrieveNbrEventsBySystemDevice(this.mf.getClassName(), this.mf.getName(), this.mse.getKeyValue(), 2, 2, 3);
                object3 = object.retrieveSeverestEventBySystemDevice(this.mf.getClassName(), this.mf.getName(), this.mse.getKeyValue(), 2, 2, 3);
            }
        }
        catch (ConnectionException connectionException) {
            Report.error.log(connectionException, (Object)"Getting alarm summary");
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Getting alarm summary");
        }
        if (object3 == null) {
            return null;
        }
        object2 = (Alarm)object3;
        object = n + " Alarms";
        return new AlarmSummaryBean((Alarm)object2, (String)object, n);
    }

    public String toString() {
        if (this.domain != null) {
            return this.domain;
        }
        String string = "Unknown";
        if (this.mse != null && this.mf != null) {
            return this.mse.getKeyValue();
        }
        if (this.mse == null && this.mf != null) {
            try {
                string = this.mf.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string == null || "".equals(string.trim())) {
                string = "Unknown";
            }
        }
        return string;
    }
}

