/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.ui.topology;

import com.sun.jade.apps.discovery.BaseServiceFinder;
import com.sun.jade.apps.topology.TopologyEvent;
import com.sun.jade.apps.topology.TopologyListener;
import com.sun.jade.apps.topology.TopologyService;
import com.sun.jade.ui.topology.TopologyModelEvent;
import com.sun.jade.ui.topology.TopologyModelListener;
import com.sun.jade.util.log.Report;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;

public class TopologyModel
implements TopologyListener {
    private static Hashtable controllers = new Hashtable();
    private Vector listeners = new Vector();
    private TopologyService service;

    private TopologyModel(String string) throws RemoteException {
        this.init(string);
    }

    private void init(String string) throws RemoteException {
        this.service = BaseServiceFinder.getTopologyService();
        if (this.service == null) {
            Report.error.log("Topology service not found.");
        } else {
            this.service.addTopologyListener(this);
        }
    }

    public static synchronized TopologyModel get(String string) throws RemoteException {
        TopologyModel topologyModel = (TopologyModel)controllers.get(string);
        if (topologyModel != null) {
            return topologyModel;
        }
        TopologyModel topologyModel2 = new TopologyModel(string);
        controllers.put(string, topologyModel2);
        return topologyModel2;
    }

    public TopologyService getService() {
        return this.service;
    }

    public void notify(TopologyEvent topologyEvent) {
        Object object = topologyEvent.getSource();
        int n = topologyEvent.getMode();
        TopologyModelEvent topologyModelEvent = new TopologyModelEvent(object, n);
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            TopologyModelListener topologyModelListener = (TopologyModelListener)this.listeners.elementAt(n2);
            topologyModelListener.notify(topologyModelEvent);
            ++n2;
        }
    }

    public void addTopologyModelListener(TopologyModelListener topologyModelListener) {
        this.listeners.add(topologyModelListener);
    }

    public void removeTopologyModelListener(TopologyModelListener topologyModelListener) {
        this.listeners.remove(topologyModelListener);
    }

    public static void main(String[] stringArray) throws RemoteException {
        if (System.getSecurityManager() == null) {
            System.out.println("Installing a security manager.");
            System.setSecurityManager(new RMISecurityManager());
        }
        String string = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
        } else {
            try {
                String string2 = InetAddress.getLocalHost().getHostName();
                string = "jiro:" + string2;
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println("Cannot find Jiro domain");
                System.exit(-1);
            }
            catch (SecurityException securityException) {
                System.err.println("Cannot find Jiro domain");
                System.exit(-1);
            }
        }
        System.out.println(string);
        TopologyModel.get(string);
    }
}

