/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.ui.jhelp;

import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.Map;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class TOCItemTag
extends BodyTagSupport {
    private Enumeration treeEnum;
    private DefaultMutableTreeNode topNode;
    private String baseID = "root";
    private HelpBroker hb;
    private boolean anyrows = false;

    public void setTocView(TOCView tOCView) {
        if (tOCView != null) {
            this.topNode = tOCView.getDataAsTree();
            this.treeEnum = this.topNode.preorderEnumeration();
        }
    }

    public void setBaseID(String string) {
        this.baseID = string;
    }

    public void setHelpBroker(HelpBroker helpBroker) {
        this.hb = helpBroker;
    }

    public int doStartTag() {
        if (this.treeEnum.hasMoreElements()) {
            return 2;
        }
        return 0;
    }

    public int doAfterBody() throws JspException {
        BodyContent bodyContent = this.getBodyContent();
        if (this.anyrows) {
            try {
                bodyContent.writeOut((Writer)this.getPreviousOut());
            }
            catch (IOException iOException) {
                throw new JspTagException("TOCItemTag: " + iOException.getMessage());
            }
        }
        bodyContent.clearBody();
        if (this.treeEnum.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeEnum.nextElement();
            if (defaultMutableTreeNode == this.topNode) {
                try {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeEnum.nextElement();
                }
                catch (NoSuchElementException noSuchElementException) {
                    return 0;
                }
            }
            TOCItem tOCItem = (TOCItem)defaultMutableTreeNode.getUserObject();
            this.pageContext.setAttribute("name", (Object)tOCItem.getName());
            String string = "";
            if (tOCItem.getID() != null) {
                string = tOCItem.getID().id;
            }
            this.pageContext.setAttribute("helpID", (Object)string);
            this.pageContext.setAttribute("parent", (Object)Integer.toHexString(defaultMutableTreeNode.getParent().hashCode()));
            String string2 = this.getID(defaultMutableTreeNode.getParent());
            this.pageContext.setAttribute("parentID", (Object)string2);
            this.pageContext.setAttribute("node", (Object)Integer.toHexString(defaultMutableTreeNode.hashCode()));
            string2 = this.getID(defaultMutableTreeNode);
            this.pageContext.setAttribute("nodeID", (Object)string2);
            String string3 = this.getContentURL(tOCItem);
            this.pageContext.setAttribute("contentURL", (Object)string3);
            String string4 = this.getIconURL(tOCItem);
            this.pageContext.setAttribute("iconURL", (Object)string4);
            this.anyrows = true;
            return 2;
        }
        return 0;
    }

    private String getID(TreeNode treeNode) {
        if (treeNode == this.topNode) {
            return this.baseID;
        }
        TreeNode treeNode2 = treeNode.getParent();
        if (treeNode2 == null) {
            return "";
        }
        String string = this.getID(treeNode2);
        string = string.concat("_" + Integer.toString(treeNode2.getIndex(treeNode)));
        return string;
    }

    private String getContentURL(TOCItem tOCItem) {
        URL uRL = null;
        Map.ID iD = tOCItem.getID();
        if (iD != null) {
            HelpSet helpSet = iD.hs;
            Map map = helpSet.getLocalMap();
            try {
                uRL = map.getURLFromID(iD);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRL == null) {
            return "";
        }
        return uRL.toExternalForm();
    }

    private String getIconURL(TOCItem tOCItem) {
        URL uRL = null;
        Map.ID iD = tOCItem.getImageID();
        if (iD != null) {
            HelpSet helpSet = iD.hs;
            Map map = helpSet.getLocalMap();
            try {
                uRL = map.getURLFromID(iD);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRL == null) {
            return "";
        }
        return uRL.toExternalForm();
    }
}

