/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.ui.jhelp;

import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class NavigatorsTag
extends BodyTagSupport {
    private HelpBroker hb;
    private HelpSet hs;
    private String curNav = null;
    private boolean anyrows = false;
    private NavigatorView[] views;
    private int i;

    public void setHelpBroker(HelpBroker helpBroker) {
        this.hb = helpBroker;
        this.hs = helpBroker.getHelpSet();
        this.views = this.hs.getNavigatorViews();
    }

    public void setCurrentNav(String string) {
        this.curNav = string;
    }

    public int doStartTag() {
        this.checkRequestParams();
        this.initCurNav();
        if (this.views.length > 0) {
            this.i = 0;
            return 2;
        }
        return 0;
    }

    private void checkRequestParams() {
        ServletRequest servletRequest = this.pageContext.getRequest();
        if (this.curNav == null) {
            this.curNav = servletRequest.getParameter("nav");
        }
    }

    private void initCurNav() {
        if (this.curNav != null) {
            try {
                this.hb.setCurrentView(this.curNav);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public int doAfterBody() throws JspException {
        BodyContent bodyContent = this.getBodyContent();
        if (this.anyrows) {
            try {
                bodyContent.writeOut((Writer)this.getPreviousOut());
            }
            catch (IOException iOException) {
                throw new JspTagException("NavigatorsTag: " + iOException.getMessage());
            }
        }
        bodyContent.clearBody();
        if (this.i < this.views.length) {
            this.pageContext.setAttribute("className", (Object)this.views[this.i].getClass().getName());
            this.pageContext.setAttribute("name", (Object)this.views[this.i].getName());
            this.pageContext.setAttribute("tip", (Object)this.views[this.i].getLabel());
            String string = this.getIconURL(this.views[this.i]);
            this.pageContext.setAttribute("iconURL", (Object)string);
            this.anyrows = true;
            ++this.i;
            return 2;
        }
        return 0;
    }

    private String getIconURL(NavigatorView navigatorView) {
        URL uRL = null;
        Map.ID iD = navigatorView.getImageID();
        if (iD != null) {
            HelpSet helpSet = iD.hs;
            Map map = helpSet.getLocalMap();
            try {
                uRL = map.getURLFromID(iD);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRL == null) {
            return "";
        }
        return uRL.toExternalForm();
    }
}

