/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.ui.diags;

import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.util.ParameterType;
import com.sun.jade.ui.diags.NotInRangeException;
import com.sun.jade.ui.diags.TestParameterRenderer;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import com.sun.wbem.cim.UnsignedInt8;
import java.awt.Component;
import java.math.BigInteger;
import javax.swing.JComboBox;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class BasicTestParameterRenderer
implements TestParameterRenderer {
    protected transient JTextField field;
    protected transient JComboBox choice;
    protected transient TestParameter p;
    protected int radix = 10;

    public BasicTestParameterRenderer() {
    }

    public BasicTestParameterRenderer(int n) {
        this.radix = n;
    }

    private JTextField getField() {
        if (this.field == null) {
            this.field = new JTextField(15);
        }
        return this.field;
    }

    private JTextField getPasswordField() {
        if (this.field == null) {
            this.field = new JPasswordField(15);
        }
        return this.field;
    }

    private JComboBox getChoice() {
        if (this.choice == null) {
            this.choice = new JComboBox();
        }
        return this.choice;
    }

    private Component getComponent(Object object, ParameterType parameterType) {
        if (object instanceof String && parameterType.equals(ParameterType.PASSWORD)) {
            this.getPasswordField().setText((String)object);
            return this.field;
        }
        if (object instanceof String) {
            if (this.p.getValidValues() == null) {
                this.getField().setText((String)object);
                return this.field;
            }
            JComboBox jComboBox = this.getChoice();
            jComboBox.removeAllItems();
            jComboBox.addItem(object);
            Object[] objectArray = this.p.getValidValues();
            int n = 0;
            while (n < objectArray.length) {
                if (!objectArray[n].equals(object)) {
                    jComboBox.addItem(objectArray[n]);
                }
                ++n;
            }
            return jComboBox;
        }
        if (object instanceof Integer) {
            String string = this.radix == 16 ? Integer.toHexString((Integer)object) : ((Integer)object).toString();
            this.getField().setText(string);
            return this.field;
        }
        if (object instanceof Float) {
            this.getField().setText(((Float)object).toString());
            return this.field;
        }
        if (object instanceof UnsignedInt8) {
            this.getField().setText(((UnsignedInt8)object).toString());
            return this.field;
        }
        if (object instanceof UnsignedInt16) {
            this.getField().setText(((UnsignedInt16)object).toString());
            return this.field;
        }
        if (object instanceof UnsignedInt32) {
            this.getField().setText(((UnsignedInt32)object).toString());
            return this.field;
        }
        if (object instanceof UnsignedInt64) {
            this.getField().setText(((UnsignedInt64)object).toString());
            return this.field;
        }
        if (object instanceof Boolean) {
            JComboBox jComboBox = this.getChoice();
            jComboBox.removeAllItems();
            jComboBox.addItem(object);
            jComboBox.addItem(new Boolean((Boolean)object == false));
            return jComboBox;
        }
        return null;
    }

    public Component getComponent(TestParameter testParameter) {
        this.p = testParameter;
        return this.getComponent(testParameter.getDefaultValue(), testParameter.getParameterType());
    }

    public void reset() {
        this.getComponent(this.p.getDefaultValue(), this.p.getParameterType());
    }

    public Object getValue() throws NotInRangeException {
        Object object = this.p.getDefaultValue();
        Object object2 = null;
        if (object instanceof String) {
            if (this.p.getValidValues() == null) {
                String string = this.field.getText();
                object2 = string;
            } else {
                object2 = this.choice.getSelectedItem();
            }
        } else if (object instanceof Integer) {
            int[] nArray;
            String string = this.field.getText();
            int n = Integer.parseInt(string, this.radix);
            Object[] objectArray = this.p.getValidValues();
            if (objectArray != null && (n < (nArray = new int[]{(Integer)objectArray[0], (Integer)objectArray[1]})[0] || n > nArray[1])) {
                throw new NotInRangeException();
            }
            object2 = new Integer(n);
        } else if (object instanceof Float) {
            float[] fArray;
            String string = this.field.getText();
            float f = Float.parseFloat(string);
            Object[] objectArray = this.p.getValidValues();
            if (objectArray != null && (f < (fArray = new float[]{((Float)objectArray[0]).floatValue(), ((Float)objectArray[1]).floatValue()})[0] || f > fArray[1])) {
                throw new NotInRangeException();
            }
            object2 = new Float(f);
        } else if (object instanceof UnsignedInt8) {
            String string = this.field.getText();
            UnsignedInt8 unsignedInt8 = new UnsignedInt8(string);
            Object[] objectArray = this.p.getValidValues();
            this.compare(unsignedInt8, objectArray);
            object2 = new UnsignedInt8(unsignedInt8.shortValue());
        } else if (object instanceof UnsignedInt16) {
            String string = this.field.getText();
            UnsignedInt16 unsignedInt16 = new UnsignedInt16(string);
            Object[] objectArray = this.p.getValidValues();
            this.compare(unsignedInt16, objectArray);
            object2 = new UnsignedInt16(unsignedInt16.intValue());
        } else if (object instanceof UnsignedInt32) {
            String string = this.field.getText();
            UnsignedInt32 unsignedInt32 = new UnsignedInt32(string);
            Object[] objectArray = this.p.getValidValues();
            this.compare(unsignedInt32, objectArray);
            object2 = new UnsignedInt32(unsignedInt32.longValue());
        } else if (object instanceof UnsignedInt64) {
            String string = this.field.getText();
            UnsignedInt64 unsignedInt64 = new UnsignedInt64(string);
            Object[] objectArray = this.p.getValidValues();
            this.compare(unsignedInt64, objectArray);
            object2 = new UnsignedInt64(unsignedInt64.toString());
        } else if (object instanceof Boolean) {
            object2 = this.choice.getSelectedItem();
        }
        return object2;
    }

    private void compare(Object object, Object[] objectArray) throws NotInRangeException {
        if (objectArray == null || objectArray.length < 2) {
            return;
        }
        if (object instanceof UnsignedInt8) {
            if (objectArray[0] instanceof UnsignedInt8) {
                short s = ((UnsignedInt8)object).shortValue();
                short s2 = ((UnsignedInt8)objectArray[0]).shortValue();
                short s3 = ((UnsignedInt8)objectArray[1]).shortValue();
                if (s < s2 || s > s3) {
                    throw new NotInRangeException();
                }
            } else {
                this.compare64(object, objectArray);
            }
        } else if (object instanceof UnsignedInt16) {
            if (objectArray[0] instanceof UnsignedInt16) {
                int n = ((UnsignedInt16)object).intValue();
                int n2 = ((UnsignedInt16)objectArray[0]).intValue();
                int n3 = ((UnsignedInt16)objectArray[1]).intValue();
                if (n < n2 || n > n3) {
                    throw new NotInRangeException();
                }
            } else {
                this.compare64(object, objectArray);
            }
        } else if (object instanceof UnsignedInt32) {
            if (objectArray[0] instanceof UnsignedInt32) {
                long l = ((UnsignedInt32)object).longValue();
                long l2 = ((UnsignedInt32)objectArray[0]).longValue();
                long l3 = ((UnsignedInt32)objectArray[1]).longValue();
                if (l < l2 || l > l3) {
                    throw new NotInRangeException();
                }
            } else {
                this.compare64(object, objectArray);
            }
        } else if (!(object instanceof UnsignedInt64) || objectArray[0] instanceof UnsignedInt64) {
            // empty if block
        }
    }

    private void compare64(Object object, Object[] objectArray) throws NotInRangeException {
        UnsignedInt64 unsignedInt64 = new UnsignedInt64(object.toString());
        UnsignedInt64 unsignedInt642 = new UnsignedInt64(objectArray[0].toString());
        UnsignedInt64 unsignedInt643 = new UnsignedInt64(objectArray[1].toString());
        if (unsignedInt64.compareTo((BigInteger)unsignedInt642) == -1 || unsignedInt64.compareTo((BigInteger)unsignedInt643) == 1) {
            throw new NotInRangeException();
        }
    }
}

