/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.services.notification.netconnect;

import com.sun.jade.services.notification.netconnect.NetConnectNotifier;
import com.sun.jade.services.notification.netconnect.NetConnectNotifierSpecification;
import com.sun.netstorage.mgmt.service.notification.ContractSpecificationException;
import com.sun.netstorage.mgmt.service.notification.NotifierSpecification;
import com.sun.netstorage.mgmt.service.nsm.notification.domestic.Notifier;
import com.sun.netstorage.mgmt.service.nsm.notification.domestic.NotifierManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class NetConnectNotifierManager
implements NotifierManager {
    private static final String PROPS_PREFIX = "netconnect";
    private static String commandName = "";
    private static String defaultCommandFlags = "";
    private static String priorityFlag = "";
    private boolean isPaused = false;
    private static Properties myProps = null;
    private HashMap notifiers = new HashMap();

    public Notifier create(NotifierSpecification notifierSpecification, long l) throws ContractSpecificationException {
        NetConnectNotifier netConnectNotifier = new NetConnectNotifier((NetConnectNotifierSpecification)notifierSpecification);
        this.notifiers.put(new Long(l), netConnectNotifier);
        if (this.isPaused()) {
            netConnectNotifier.pause();
        } else {
            netConnectNotifier.resume();
        }
        return netConnectNotifier;
    }

    public void destroy(long l, boolean bl) throws ContractSpecificationException {
        NetConnectNotifier netConnectNotifier = (NetConnectNotifier)this.notifiers.remove(new Long(l));
        if (netConnectNotifier == null) {
            throw new ContractSpecificationException(202);
        }
        netConnectNotifier.unschedule();
    }

    public void setNotifierProperties(Properties properties) {
        myProps = properties;
        String string = NetConnectNotifierManager.getVersion();
        commandName = properties.getProperty(string + ".commandName");
        defaultCommandFlags = properties.getProperty(string + ".defaultCommandFlags");
        priorityFlag = properties.getProperty(string + ".priorityFlag");
        myProps = properties;
    }

    public Properties getNotifierProperties() {
        return myProps;
    }

    protected static String getVersion() {
        return myProps.getProperty("version");
    }

    protected static String getInstallDir() {
        return myProps.getProperty("installDir");
    }

    protected static String getPayloadPath() {
        return myProps.getProperty("payloadPath");
    }

    protected static boolean isCompressEvents() {
        boolean bl = false;
        String string = myProps.getProperty("compressEvents");
        if (string != null) {
            Boolean bl2 = new Boolean(string);
            bl = bl2;
        }
        return bl;
    }

    public static String getCommandName() {
        return commandName;
    }

    public static String getDefaultCommandFlags() {
        return defaultCommandFlags;
    }

    public static String getPriorityFlag() {
        return priorityFlag;
    }

    public void resume() {
        this.isPaused = false;
        Iterator iterator = this.notifiers.values().iterator();
        while (iterator.hasNext()) {
            Notifier notifier = (Notifier)iterator.next();
            notifier.resume();
        }
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public void pause() {
        this.isPaused = true;
        Iterator iterator = this.notifiers.values().iterator();
        while (iterator.hasNext()) {
            Notifier notifier = (Notifier)iterator.next();
            notifier.pause();
        }
    }

    public void modify(long l, NotifierSpecification notifierSpecification) throws ContractSpecificationException {
        this.destroy(l, false);
        this.create(notifierSpecification, l);
    }
}

