/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.services.notification.netconnect;

import com.sun.jade.event.NSMEvent;
import com.sun.jade.services.notification.LogServiceAdapter;
import com.sun.jade.services.notification.ModificationException;
import com.sun.jade.services.notification.Modifier;
import com.sun.jade.services.notification.NWSNotifier;
import com.sun.jade.services.notification.Scheduler;
import com.sun.jade.services.notification.netconnect.NetConnectNotifierManager;
import com.sun.jade.services.notification.netconnect.NetConnectNotifierSpecification;
import com.sun.netstorage.mgmt.service.event.AbstractEvent;
import com.sun.netstorage.mgmt.service.notification.ContractSpecificationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class NetConnectNotifier
extends NWSNotifier
implements Runnable {
    private static final int EXIT_OK = 0;
    public static final String COMP_NAME = "NetConnectNotifier";
    private static final String NC_EXTENSION = ".nc";
    private static final String PRIORITY_PREFIX = ".P";
    private static final String EXTENSION = ".ev";
    private static List filesBeingProcessed = new ArrayList();
    private Scheduler.Ticket ticket;
    private Modifier modifier = null;
    private NetConnectNotifierSpecification ncspec = null;
    private boolean paused = false;

    public NetConnectNotifier(NetConnectNotifierSpecification netConnectNotifierSpecification) throws ContractSpecificationException {
        super(netConnectNotifierSpecification);
        this.ncspec = netConnectNotifierSpecification;
        if (this.ncspec.getImmediate() == null || !this.ncspec.getImmediate().booleanValue()) {
            this.doSchedule();
        }
    }

    private void doSchedule() {
        LogServiceAdapter.log("trace", COMP_NAME, "Setting up a schedule.");
        Scheduler.Ticket ticket = null;
        ticket = this.ncspec.getInterval() != null ? Scheduler.scheduleTask(this.ncspec.getInterval(), this) : Scheduler.scheduleTask((int)this.ncspec.getRecurringHourOfDay(), this.ncspec.getRecurringMinuteOfHour(), (Runnable)this);
        this.ticket = ticket;
    }

    public void unschedule() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }

    public void notify(AbstractEvent abstractEvent) {
        if (this.paused) {
            LogServiceAdapter.log("trace", COMP_NAME, "Received notification of event " + ((NSMEvent)abstractEvent).getEventID() + " but I am paused.  Discarding...");
            return;
        }
        LogServiceAdapter.log("trace", COMP_NAME, "Notify called.  Immediate = " + this.ncspec.getImmediate());
        try {
            this.preNotify(abstractEvent);
        }
        catch (ModificationException modificationException) {
            LogServiceAdapter.log("error", COMP_NAME, "PreNotify failed due to an exception while modifying an event's payload.  This event will be ignored.", modificationException);
            Exception exception = modificationException.getNestedException();
            if (exception != null) {
                LogServiceAdapter.log("error", COMP_NAME, "Nested Exception was: ", exception);
            }
            this.logEvent((NSMEvent)abstractEvent);
            return;
        }
        this.writeEvent(abstractEvent);
        if (this.ncspec.getImmediate() != null && this.ncspec.getImmediate().booleanValue()) {
            this.runNetConnect();
        }
    }

    private void writeEvent(AbstractEvent abstractEvent) {
        NSMEvent nSMEvent = (NSMEvent)abstractEvent;
        LogServiceAdapter.log("trace", COMP_NAME, "writeEvent()");
        String string = NetConnectNotifierManager.getPayloadPath() + "/" + nSMEvent.getSourceSequenceNumber() + PRIORITY_PREFIX + this.getPriority(abstractEvent) + EXTENSION;
        try {
            Object object;
            String string2 = nSMEvent.toXML();
            FileOutputStream fileOutputStream = new FileOutputStream(string, true);
            if (NetConnectNotifierManager.isCompressEvents()) {
                object = new GZIPOutputStream(fileOutputStream);
                ((FilterOutputStream)object).write(string2.getBytes());
                ((DeflaterOutputStream)object).flush();
                ((DeflaterOutputStream)object).close();
            } else {
                object = new PrintStream(fileOutputStream);
                ((PrintStream)object).println(string2);
                ((PrintStream)object).flush();
                ((PrintStream)object).close();
            }
            fileOutputStream.close();
            object = new File(string);
            File file = new File(string + NC_EXTENSION);
            boolean bl = ((File)object).renameTo(file);
            if (!bl) {
                LogServiceAdapter.log("error", COMP_NAME, "Could not rename file " + ((File)object).getAbsolutePath() + "/" + ((File)object).getName() + " to " + file.getAbsolutePath() + "/" + file.getName() + ".  This file will not be sent to NetConnect.");
            }
        }
        catch (IOException iOException) {
            LogServiceAdapter.log("error", COMP_NAME, "Failed to write event payload to file " + string, iOException);
        }
    }

    public void run() {
        if (this.paused) {
            LogServiceAdapter.log("trace", COMP_NAME, "Executing scheduled retry, but am paused.  Will not execute.  Event will be left in cache for delivery once resumed.");
        } else {
            this.runNetConnect();
        }
    }

    private synchronized void markAsBeingProcessed(File[] fileArray, boolean bl) {
        int n = 0;
        while (n < fileArray.length) {
            if (bl) {
                filesBeingProcessed.add(fileArray[n]);
            } else {
                filesBeingProcessed.remove(fileArray[n]);
            }
            ++n;
        }
    }

    private boolean beingProcessed(File file) {
        return filesBeingProcessed.contains(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNetConnect() {
        if (this.paused) {
            return;
        }
        LogServiceAdapter.log("trace", COMP_NAME, "Running NetConnect");
        File[] fileArray = null;
        NetConnectNotifier netConnectNotifier = this;
        synchronized (netConnectNotifier) {
            fileArray = new File(NetConnectNotifierManager.getPayloadPath()).listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(NetConnectNotifier.NC_EXTENSION) && !NetConnectNotifier.this.beingProcessed(new File(file.getAbsoluteFile() + "/" + string));
                }
            });
            LogServiceAdapter.log("trace", COMP_NAME, "Found " + fileArray.length + " files to process.");
            if (fileArray.length == 0) {
                return;
            }
            this.markAsBeingProcessed(fileArray, true);
        }
        int n = 0;
        while (n < fileArray.length) {
            String string = fileArray[n].getAbsolutePath();
            int n2 = string.indexOf(PRIORITY_PREFIX);
            int n3 = n2 + PRIORITY_PREFIX.length();
            int n4 = n3 + 1;
            String string2 = string.substring(n3, n4);
            String string3 = NetConnectNotifierManager.getInstallDir() + "/" + NetConnectNotifierManager.getCommandName() + " " + NetConnectNotifierManager.getPriorityFlag() + " " + string2 + " " + NetConnectNotifierManager.getDefaultCommandFlags() + " " + string;
            try {
                int n5 = -1;
                LogServiceAdapter.log("trace", COMP_NAME, "Execing command: " + string3);
                Process process = Runtime.getRuntime().exec(string3);
                InputStream inputStream = process.getErrorStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string4 = null;
                while ((string4 = bufferedReader.readLine()) != null) {
                    LogServiceAdapter.log("error", COMP_NAME, "STDERR: " + string4);
                }
                LogServiceAdapter.log("debug", COMP_NAME, "Command exited.");
                n5 = process.waitFor();
                if (n5 != 0) {
                    LogServiceAdapter.log("error", COMP_NAME, "Execution of command (" + string3 + ") exited abnormally with status " + n5);
                    LogServiceAdapter.log("error", COMP_NAME, "Aborting NetConnect transfer.  Will not send additional files until next scheduled execution.");
                    break;
                }
                boolean bl = fileArray[n].delete();
                if (!bl) {
                    LogServiceAdapter.log("error", COMP_NAME, "Deletion of file " + fileArray[n] + " failed.");
                }
            }
            catch (Exception exception) {
                LogServiceAdapter.log("error", COMP_NAME, "Execution of NetConnect command (" + string3 + ") encountered an exception.", exception);
            }
            ++n;
        }
        this.markAsBeingProcessed(fileArray, false);
    }

    public void resume() {
        this.paused = false;
    }

    public void pause() {
        this.paused = true;
    }

    private int getPriority(AbstractEvent abstractEvent) {
        int n = abstractEvent.getSeverity();
        if (n >= 5) {
            return 1;
        }
        if (n >= 3) {
            return 2;
        }
        return 3;
    }
}

