/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.services.notification;

import com.sun.jade.event.NSMEvent;
import com.sun.jade.services.notification.LogServiceAdapter;
import com.sun.jade.services.notification.ModificationException;
import com.sun.jade.services.notification.Modifier;
import com.sun.jade.services.notification.NWSNotifierSpecification;
import com.sun.jade.services.notification.NotificationProperties;
import com.sun.jade.services.notification.SimpleXMLModifier;
import com.sun.netstorage.mgmt.service.event.AbstractEvent;
import com.sun.netstorage.mgmt.service.nsm.notification.domestic.Notifier;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public abstract class NWSNotifier
implements Notifier {
    public static final String BAD_EVENT_DIR_PROPERTY = "notificationService.invalidEventDir";
    public static final String BAD_XML_EVENT_EXTENSION = ".ev.xml.invalid";
    public static final String BAD_SER_EVENT_EXTENSION = ".ev.ser.invalid";
    private Modifier[] modifiers;
    private static final String COMP_NAME = "NWSNotifier";
    private NWSNotifierSpecification spec = null;

    public NWSNotifier(NWSNotifierSpecification nWSNotifierSpecification) {
        this.setSpec(nWSNotifierSpecification);
    }

    public NWSNotifierSpecification getSpec() {
        return this.spec;
    }

    public void setSpec(NWSNotifierSpecification nWSNotifierSpecification) {
        this.spec = nWSNotifierSpecification;
    }

    public void preNotify(AbstractEvent abstractEvent) throws ModificationException {
        if (this.spec.getModifierTypes() == null) {
            return;
        }
        if (this.modifiers == null) {
            List list = this.spec.getModifierTypes();
            int n = 0;
            this.modifiers = new Modifier[list.size()];
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.modifiers[n++] = this.createModifier(string);
            }
        }
        if (this.modifiers.length == 0) {
            return;
        }
        int n = 0;
        while (n < this.modifiers.length) {
            this.modifiers[n].modify(abstractEvent);
            ++n;
        }
    }

    private Modifier createModifier(String string) {
        if (string == null) {
            return null;
        }
        try {
            return (Modifier)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void logEvent(NSMEvent nSMEvent) {
        LogServiceAdapter.log("trace", COMP_NAME, "Logging bad event " + nSMEvent.getEventID());
        Properties properties = NotificationProperties.getProperties();
        String string = properties.getProperty(BAD_EVENT_DIR_PROPERTY);
        String string2 = null;
        NSMEvent nSMEvent2 = null;
        try {
            LogServiceAdapter.log("trace", COMP_NAME, "Cloning event.");
            nSMEvent2 = nSMEvent.cloneEvent();
            string2 = string + "/" + nSMEvent.getEventID() + BAD_XML_EVENT_EXTENSION;
            LogServiceAdapter.log("trace", COMP_NAME, "Writing event as XML to file " + string2 + ".");
            SimpleXMLModifier simpleXMLModifier = new SimpleXMLModifier();
            simpleXMLModifier.modify(nSMEvent2);
            FileWriter fileWriter = new FileWriter(string2);
            fileWriter.write(((String)nSMEvent2.getPayload()).toCharArray());
            fileWriter.close();
        }
        catch (Exception exception) {
            LogServiceAdapter.log("error", COMP_NAME, "Failed to write bad event to file " + string2 + " using SimpleXMLModifier.  Will try serialization.", exception);
            try {
                string2 = string + "/" + nSMEvent.getEventID() + BAD_SER_EVENT_EXTENSION;
                LogServiceAdapter.log("trace", COMP_NAME, "Serializing event to file " + string2 + ".");
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string2));
                objectOutputStream.writeObject(nSMEvent2);
                objectOutputStream.close();
            }
            catch (Exception exception2) {
                LogServiceAdapter.log("error", COMP_NAME, "Failed to write bad event to file " + string2 + " using Serialization.  Bummer!", exception2);
            }
        }
    }
}

