/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.services.notification;

import com.sun.jade.util.PropertiesPersistenceException;
import com.sun.jade.util.PropertiesPersister;
import com.sun.jade.util.log.Logger;
import com.sun.jade.util.log.Report;
import java.util.ArrayList;
import java.util.Properties;

public class LogServiceAdapter {
    public static final String ERROR = "error";
    public static final String TRACE = "trace";
    public static final String DEBUG = "debug";

    private static void loadTags(Logger logger, String string, Properties properties) {
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            logger.enableLogging();
            String[] stringArray = LogServiceAdapter.explode(string2, ',');
            int n = 0;
            while (n < stringArray.length) {
                logger.addTag(stringArray[n]);
                ++n;
            }
        }
    }

    public static void log(String string, String string2, String string3, Exception exception) {
        Logger logger = null;
        if (string.equals(ERROR)) {
            logger = Report.error;
        } else if (string.equals(DEBUG)) {
            logger = Report.debug;
        } else if (string.equals(TRACE)) {
            logger = Report.trace;
        }
        if (string2 != null && string3 != null && exception != null) {
            logger.log(string2, exception, string3);
        } else if (string2 != null && string3 != null) {
            logger.log(string2, (Object)string3);
        } else if (string3 != null && exception != null) {
            logger.log(exception, (Object)string3);
        }
    }

    public static void log(String string, String string2, String string3) {
        LogServiceAdapter.log(string, string2, string3, null);
    }

    public static void log(String string, String string2, Exception exception) {
        LogServiceAdapter.log(string, null, string2, exception);
    }

    private static String[] explode(String string, char c) {
        int n;
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.indexOf(c, 0) == -1) {
            arrayList.add(string);
        } else {
            int n2 = 0;
            n = 0;
            do {
                if ((n = string.indexOf(c, n2)) == -1) {
                    if (n2 == 0) break;
                    arrayList.add(string.substring(n2));
                    break;
                }
                arrayList.add(string.substring(n2, n));
            } while ((n2 = n + 1) <= string.length());
        }
        String[] stringArray = new String[arrayList.size()];
        n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)arrayList.get(n);
            ++n;
        }
        return stringArray;
    }

    static {
        try {
            Properties properties = PropertiesPersister.restoreProperties("NotificationService.properties");
            LogServiceAdapter.loadTags(Report.trace, "notificationService.log.trace", properties);
            LogServiceAdapter.loadTags(Report.error, "notificationService.log.error", properties);
            LogServiceAdapter.loadTags(Report.error, "notificationService.log.debug", properties);
        }
        catch (PropertiesPersistenceException propertiesPersistenceException) {
            Report.error.log("Failed to load properties from file NotificationService.properties logging will not work.", (Object)propertiesPersistenceException);
        }
    }
}

