/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.services.logging;

import com.sun.jade.services.logging.LogIterator;
import com.sun.jade.services.logging.LogMessageFilter;
import com.sun.jade.services.logging.LogService;
import com.sun.jade.util.log.Report;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogServiceImpl
implements LogService {
    String logDirName = "/tmp/";
    String logFileName = "StorAde.log";
    private Logger logger = Logger.getLogger("com.sun.jade");
    private static final String sccs_id = "@(#)LogServiceImpl.java\t1.3 05/02/02 SMI";

    public LogServiceImpl() {
        try {
            FileHandler fileHandler = new FileHandler(this.getLogPath());
            this.logger.addHandler(fileHandler);
        }
        catch (IOException iOException) {
            Report.warning.log(iOException, (Object)"Failed to assign logger to file");
        }
        this.logger.setLevel(Level.ALL);
    }

    private String getLogPath() {
        return this.logDirName + this.logFileName;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Iterator search(Filter filter) {
        return new LogIterator(filter, this.getLogPath());
    }

    public static void main(String[] stringArray) {
        LogRecord logRecord;
        LogServiceImpl logServiceImpl = new LogServiceImpl();
        Logger logger = logServiceImpl.getLogger();
        logger.info("Starting");
        logger.log(Level.SEVERE, "Severe message.");
        logger.log(Level.WARNING, "Warning message.");
        logger.log(Level.INFO, "Info message.");
        logger.log(Level.CONFIG, "Config message.");
        logger.log(Level.FINE, "Fine message.");
        logger.log(Level.FINER, "Finer message.");
        logger.log(Level.FINEST, "Finest message.");
        Iterator iterator = logServiceImpl.search(null);
        while (iterator.hasNext()) {
            logRecord = (LogRecord)iterator.next();
            System.out.println("Log:");
            System.out.println("    level    " + logRecord.getLevel());
            System.out.println("    name    = " + logRecord.getLoggerName());
            System.out.println("    millis  = " + logRecord.getMillis());
            System.out.println("    number  = " + logRecord.getSequenceNumber());
            System.out.println("    message = " + logRecord.getMessage());
        }
        System.out.println("No more logs");
        iterator = logServiceImpl.search(new LogMessageFilter("Fine"));
        while (iterator.hasNext()) {
            logRecord = (LogRecord)iterator.next();
            System.out.println("Log:");
            System.out.println("    level    " + logRecord.getLevel());
            System.out.println("    name    = " + logRecord.getLoggerName());
            System.out.println("    millis  = " + logRecord.getMillis());
            System.out.println("    number  = " + logRecord.getSequenceNumber());
            System.out.println("    message = " + logRecord.getMessage());
        }
        System.out.println("No more logs");
        System.exit(0);
    }
}

