/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.services.logging;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LogIterator
implements Iterator {
    LogRecord record;
    boolean isParsing;
    Filter filter;
    private static final String sccs_id = "@(#)LogIterator.java\t1.4 05/02/02 SMI";

    LogIterator(Filter filter, String string) {
        this.filter = filter;
        String string2 = null;
        try {
            string2 = new File(string).toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (string2 != null) {
            RecordParser recordParser = new RecordParser(string2);
            this.isParsing = true;
            recordParser.start();
        }
    }

    public synchronized boolean hasNext() {
        while (this.isParsing && this.record == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.record != null;
    }

    public synchronized Object next() {
        if (this.hasNext()) {
            LogRecord logRecord = this.record;
            this.record = null;
            this.notifyAll();
            return logRecord;
        }
        return null;
    }

    public void remove() {
    }

    private synchronized void setRecord(LogRecord logRecord) {
        while (this.record != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.record = logRecord;
        this.notifyAll();
    }

    private synchronized void done() {
        this.isParsing = false;
        this.notifyAll();
    }

    static class LogResolver
    implements EntityResolver {
        LogResolver() {
        }

        public InputSource resolveEntity(String string, String string2) {
            if (string2.endsWith("logger.dtd")) {
                StringReader stringReader = new StringReader("<!ELEMENT log ANY>\n<!ELEMENT record ANY>\n");
                return new InputSource(stringReader);
            }
            return null;
        }
    }

    static class LogErrorHandler
    implements ErrorHandler {
        LogErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) {
        }

        public void warning(SAXParseException sAXParseException) {
        }

        public void fatalError(SAXParseException sAXParseException) {
        }
    }

    private class RecordParser
    extends Thread
    implements DocumentHandler {
        LogRecord r;
        String currentElement;
        String uri;
        Locator locator;
        Parser parser = null;

        RecordParser(String string) {
            this.uri = string;
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setValidating(false);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                this.parser = sAXParser.getParser();
                this.parser.setDocumentHandler(this);
                this.parser.setEntityResolver(new LogResolver());
                this.parser.setErrorHandler(new LogErrorHandler());
            }
            catch (Exception exception) {
                LogIterator.this.done();
            }
        }

        public void run() {
            if (this.parser != null) {
                try {
                    this.parser.parse(this.uri);
                }
                catch (SAXException sAXException) {
                    LogIterator.this.done();
                }
                catch (IOException iOException) {
                    LogIterator.this.done();
                }
            }
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            if ("record".equals(string)) {
                this.r = new LogRecord(Level.FINEST, "");
            }
            this.currentElement = string;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            String string = new String(cArray, n, n2);
            if ("millis".equals(this.currentElement)) {
                this.r.setMillis(Long.parseLong(string));
            } else if ("logger".equals(this.currentElement)) {
                this.r.setLoggerName(string);
            } else if ("level".equals(this.currentElement)) {
                this.r.setLevel(Level.parse(string));
            } else if ("thread".equals(this.currentElement)) {
                this.r.setThreadID(Integer.parseInt(string));
            } else if ("message".equals(this.currentElement)) {
                this.r.setMessage(string);
            }
        }

        public void endElement(String string) throws SAXException {
            if ("record".equals(string)) {
                if (LogIterator.this.filter == null) {
                    LogIterator.this.setRecord(this.r);
                } else if (LogIterator.this.filter.isLoggable(this.r)) {
                    LogIterator.this.setRecord(this.r);
                }
                this.r = null;
            }
            this.currentElement = null;
        }

        public void endDocument() throws SAXException {
            LogIterator.this.done();
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        public void processingInstruction(String string, String string2) {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }
}

