/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.policy;

import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.cim.bean.CIM_DiskDrive;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanUtil;
import com.sun.jade.event.EventGenerator;
import com.sun.jade.event.ModificationEventData;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.policy.Condition;
import com.sun.jade.policy.Context;
import com.sun.jade.services.event.AbstractEventSubscriber;
import com.sun.jade.util.PropertiesPersistenceException;
import com.sun.jade.util.jini.BaseServiceFinder;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.service.event.AbstractEvent;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class ValueChangeCondition
extends Condition {
    private String memberName = null;
    private String className = null;
    private Set baselineValueSet = new HashSet();
    private String baselineValues = null;
    private Object constant;
    private PersistenceService persistenceService;
    public static final String TARGET_ATTR = ".TargetAttr";
    public static final String TARGET_CLASS = ".TargetClass";
    public static final String BASELINE_VALUES = ".BaselineValues";
    private static final String[] propertyNames = new String[]{".TargetAttr", ".TargetClass", ".BaselineValues"};
    private Map propertyValues;

    public static String[] getPropertyNames() {
        return propertyNames;
    }

    public ValueChangeCondition(String string) {
        super(string);
    }

    public boolean evaluate(Collection collection, Context context) {
        Iterator iterator = collection.iterator();
        Object var4_4 = null;
        boolean bl = false;
        if (!iterator.hasNext()) {
            Report.trace.log("Bean Collection is empty");
            return false;
        }
        Object e = iterator.next();
        Object var7_7 = null;
        if (iterator.hasNext()) {
            var7_7 = iterator.next();
        }
        if (e != null) {
            Object object;
            Object object2;
            if (this.className != null) {
                try {
                    object2 = Class.forName(this.className);
                    if (!((Class)object2).isAssignableFrom(e.getClass())) {
                        return false;
                    }
                    Report.trace.log("Policy", (Object)("MATCHED CLASS: " + e.getClass().getName()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Report.error.log("No class found with name " + this.className);
                    return false;
                }
            }
            if ((object2 = CIMBeanUtil.getAttributeValue((CIMBean)e, this.memberName)) == null) {
                Report.warning.log("Policy", (Object)("Cannot retrieve the attribute " + this.memberName + " from the source object."));
                return false;
            }
            context.saveAttr(this.getConditionName(), "currentValue", object2.toString());
            Object object3 = object = var7_7 == null ? null : CIMBeanUtil.getAttributeValue(var7_7, this.memberName);
            if (object == null) {
                String string = object2.toString();
                return !this.baselineValueSet.isEmpty() && !this.baselineValueSet.contains(string);
            }
            Report.trace.log("Policy", (Object)("Evaluate " + this.memberName + " " + object2 + "=" + object));
            context.saveAttr(this.getConditionName(), "previousValue", object.toString());
            return !CIMBeanUtil.attributeEquals(object2, object);
        }
        return bl;
    }

    public boolean evaluate(NSMEvent nSMEvent, Context context) {
        Report.trace.log("Policy", (Object)("Evaluating " + nSMEvent));
        if (!Condition.isModificationEvent(nSMEvent)) {
            return false;
        }
        ModificationEventData modificationEventData = null;
        try {
            modificationEventData = new ModificationEventData(nSMEvent);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Report.info.log("Policy", (Object)("ValueChangeCondition (" + this.getConditionName() + ") cannot parse event"));
            return false;
        }
        CIMBean cIMBean = modificationEventData.getPreviousInstance();
        CIMBean cIMBean2 = modificationEventData.getCurrentInstance();
        String string = Condition.getAttribute(cIMBean, this.memberName);
        String string2 = Condition.getAttribute(cIMBean2, this.memberName);
        if (string != null && string2 != null) {
            context.saveAttr(this.getConditionName(), "currentValue", string2.toString());
            context.saveAttr(this.getConditionName(), "previousValue", string.toString());
            return !string2.equals(string);
        }
        if (string2 != null) {
            context.saveAttr(this.getConditionName(), "currentValue", string2.toString());
            String string3 = string2.toString();
            return !this.baselineValueSet.isEmpty() && !this.baselineValueSet.contains(string3);
        }
        return false;
    }

    public Properties toProperties() throws PropertiesPersistenceException {
        Properties properties = super.toProperties();
        this.propertyValues.put(TARGET_ATTR, this.memberName);
        this.propertyValues.put(TARGET_CLASS, this.className);
        this.writeProperties(properties, propertyNames, this.propertyValues);
        return properties;
    }

    public void fromProperties(Properties properties) throws PropertiesPersistenceException {
        this.propertyValues = this.readProperties(properties, propertyNames);
        this.memberName = (String)this.propertyValues.get(TARGET_ATTR);
        this.className = (String)this.propertyValues.get(TARGET_CLASS);
        String string = (String)this.propertyValues.get(BASELINE_VALUES);
        if (this.memberName == null) {
            throw new PropertiesPersistenceException(this.getConditionName() + " ValueChangeCondition is missing the TargetAttribute Property");
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                this.baselineValueSet.add(string2);
            }
        }
    }

    public static void main(String[] stringArray) {
        Test test = new Test();
        test.printUnitTest = true;
        System.out.println("Running Unit Test for ValueChangeCondition");
        test.testValueChangeCondition();
        test.testValueChangeCondition_2();
        System.out.println("Finished Unit Test for ValueChangeCondition");
    }

    public static class Test
    extends UnitTest
    implements AbstractEventSubscriber {
        public boolean printUnitTest = false;

        public void testValueChangeCondition() {
            CIM_DiskDrive cIM_DiskDrive = new CIM_DiskDrive();
            cIM_DiskDrive.setMediaIsLocked(Boolean.FALSE);
            cIM_DiskDrive.setErrorMethodology("new");
            cIM_DiskDrive.setMaxMediaSize(new UnsignedInt64("12345"));
            cIM_DiskDrive.setCapabilityDescriptions(new String[]{"a", "b"});
            cIM_DiskDrive.setNumberOfMediaSupported(new UnsignedInt32(2L));
            CIM_DiskDrive cIM_DiskDrive2 = new CIM_DiskDrive();
            cIM_DiskDrive2.setMediaIsLocked(Boolean.FALSE);
            cIM_DiskDrive2.setErrorMethodology("old");
            cIM_DiskDrive2.setMaxMediaSize(new UnsignedInt64("12345"));
            cIM_DiskDrive2.setCapabilityDescriptions(new String[]{"a", "b"});
            cIM_DiskDrive2.setNumberOfMediaSupported(new UnsignedInt32(2L));
            if (this.printUnitTest) {
                System.out.println("Generating Modification Event - Error Methodology old->new");
            }
            ModificationEventData modificationEventData = new ModificationEventData(1, "subject", 1L, cIM_DiskDrive.getCIMObjectPath().toString(), 1L, ".state.update", "StateChange", null, new LocalizedString("description"), 1L, "", (CIMBean)cIM_DiskDrive2, (CIMBean)cIM_DiskDrive);
            BaseServiceFinder.getEventService().subscribe(this, ".state.update");
            EventGenerator.generateEvent(modificationEventData);
        }

        public void notify(AbstractEvent abstractEvent) {
            ValueChangeCondition valueChangeCondition = new ValueChangeCondition("test");
            Properties properties = new Properties();
            properties.setProperty("Condition.test.TargetAttr", "errorMethodology");
            try {
                valueChangeCondition.fromProperties(properties);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Context context = new Context();
            if (this.printUnitTest) {
                System.out.println("Asserting that Value Change returns true for event evaluation.");
            }
            this.assertCondition(valueChangeCondition.evaluate((NSMEvent)abstractEvent, context));
        }

        public void testValueChangeCondition_2() {
            Context context;
            ValueChangeCondition valueChangeCondition = new ValueChangeCondition("test1");
            Vector<CIM_DiskDrive> vector = new Vector<CIM_DiskDrive>();
            CIM_DiskDrive cIM_DiskDrive = new CIM_DiskDrive();
            cIM_DiskDrive.setMediaIsLocked(Boolean.FALSE);
            cIM_DiskDrive.setErrorMethodology("new");
            cIM_DiskDrive.setMaxMediaSize(new UnsignedInt64("12345"));
            cIM_DiskDrive.setCapabilityDescriptions(new String[]{"a", "b"});
            cIM_DiskDrive.setNumberOfMediaSupported(new UnsignedInt32(2L));
            vector.add(cIM_DiskDrive);
            CIM_DiskDrive cIM_DiskDrive2 = new CIM_DiskDrive();
            cIM_DiskDrive2.setMediaIsLocked(Boolean.FALSE);
            cIM_DiskDrive2.setErrorMethodology("old");
            cIM_DiskDrive2.setMaxMediaSize(new UnsignedInt64("12345"));
            cIM_DiskDrive2.setCapabilityDescriptions(new String[]{"a", "b"});
            cIM_DiskDrive2.setNumberOfMediaSupported(new UnsignedInt32(2L));
            vector.add(cIM_DiskDrive2);
            Properties properties = new Properties();
            properties.setProperty("Condition.test1.TargetAttr", "ErrorMethodology");
            properties.setProperty("Condition.test1.TargetClass", "com.sun.jade.cim.bean.CIM_DiskDrive");
            try {
                valueChangeCondition.fromProperties(properties);
                context = new Context();
                if (this.printUnitTest) {
                    System.out.println("Testing collection - No baseline");
                }
                this.assertCondition(valueChangeCondition.evaluate(vector, context));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            properties = new Properties();
            properties.setProperty("Condition.test2.TargetAttr", "ErrorMethodology");
            properties.setProperty("Condition.test2.TargetClass", "com.sun.jade.cim.bean.CIM_DiskDrive");
            valueChangeCondition = new ValueChangeCondition("test2");
            vector = new Vector();
            vector.add(cIM_DiskDrive2);
            try {
                valueChangeCondition.fromProperties(properties);
                context = new Context();
                if (this.printUnitTest) {
                    System.out.println("Testing collection - without baseline going to a bad state");
                }
                this.assertCondition(!valueChangeCondition.evaluate(vector, context));
                properties.setProperty("Condition.test2.BaselineValues", "new");
                valueChangeCondition.fromProperties(properties);
                context = new Context();
                if (this.printUnitTest) {
                    System.out.println("Testing collection - with baseline going to bad state");
                }
                this.assertCondition(valueChangeCondition.evaluate(vector, context));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

