/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.policy;

import com.sun.jade.event.NSMEvent;
import com.sun.jade.policy.Condition;
import com.sun.jade.policy.Context;
import com.sun.jade.util.PropertiesPersistenceException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class TimeCondition
extends Condition {
    private String name = null;
    private Date[] timePeriod = null;
    private int[] monthOfYearMask;
    private int[] dayOfMonthMask;
    private int[] dayOfWeekMask;
    private long[] timeOfDayMask;
    private String localOrUTCTime = null;
    public static final String TIME_OF_DAY_MASK = ".TimeOfDayMask";
    public static final String LOCAL_OR_UTC_TIME = ".LocalOrUTCTime";
    private static final String[] propertyNames = new String[]{".TimeOfDayMask", ".LocalOrUTCTime"};
    private Map propertyValues;

    public static String[] getPropertyNames() {
        return propertyNames;
    }

    public TimeCondition(String string) {
        super(string);
    }

    public boolean evaluate(Collection collection, Context context) throws IllegalAccessException {
        return this.doevaluate(context);
    }

    public boolean evaluate(NSMEvent nSMEvent, Context context) throws IllegalAccessException {
        return this.doevaluate(context);
    }

    private boolean doevaluate(Context context) throws IllegalAccessException {
        int n;
        int n2;
        int n3;
        Calendar calendar = null;
        boolean bl = false;
        calendar = this.localOrUTCTime.equalsIgnoreCase("UTC") ? Calendar.getInstance(TimeZone.getTimeZone("GMT-0:00")) : Calendar.getInstance(TimeZone.getDefault());
        if (this.timePeriod != null) {
            Arrays.sort(this.timePeriod);
            Date date = calendar.getTime();
            if (this.timePeriod.length > 1) {
                if (date.before(this.timePeriod[0]) || date.after(this.timePeriod[this.timePeriod.length - 1])) {
                    return false;
                }
                if (this.timePeriod.length == 1 && date.before(this.timePeriod[0])) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (this.timeOfDayMask != null) {
            long l = calendar.getTime().getTime();
            Arrays.sort(this.timeOfDayMask);
            if (l >= this.timeOfDayMask[0] && l <= this.timeOfDayMask[this.timeOfDayMask.length - 1]) {
                bl = true;
            }
        }
        int n4 = calendar.get(7);
        if (this.dayOfWeekMask != null) {
            n3 = 0;
            Arrays.sort(this.dayOfWeekMask);
            n2 = 0;
            while (n2 < this.dayOfWeekMask.length) {
                if (n4 == this.dayOfWeekMask[n2]) {
                    n3 = 1;
                }
                ++n2;
            }
            bl = bl && n3 != 0;
        }
        n3 = calendar.get(5);
        if (this.dayOfMonthMask != null) {
            n2 = 0;
            Arrays.sort(this.dayOfMonthMask);
            n = 0;
            while (n < this.dayOfMonthMask.length) {
                if (n3 == this.dayOfMonthMask[n]) {
                    n2 = 1;
                }
                ++n;
            }
            bl = bl && n2 != 0;
        }
        n2 = calendar.get(2);
        if (this.monthOfYearMask != null) {
            n = 0;
            Arrays.sort(this.monthOfYearMask);
            int n5 = 0;
            while (n5 < this.monthOfYearMask.length) {
                if (n2 + 9 == this.monthOfYearMask[n5]) {
                    n = 1;
                }
                ++n5;
            }
            bl = bl && n != 0;
        }
        return bl;
    }

    public Properties toProperties() throws PropertiesPersistenceException {
        Properties properties = super.toProperties();
        this.writeProperties(properties, propertyNames, this.propertyValues);
        return properties;
    }

    public void fromProperties(Properties properties) throws PropertiesPersistenceException {
        this.propertyValues = this.readProperties(properties, propertyNames);
        String string = this.getConditionName();
        String string2 = (String)this.propertyValues.get(TIME_OF_DAY_MASK);
        long[] lArray = new long[]{Long.parseLong(string2)};
        this.timeOfDayMask = lArray;
        this.localOrUTCTime = (String)this.propertyValues.get(LOCAL_OR_UTC_TIME);
        if (this.timeOfDayMask == null || this.localOrUTCTime == null) {
            throw new PropertiesPersistenceException(string + " Time Condition " + " is missing either TimeOfDayMask or LocalOrUTC Property");
        }
    }

    public static void main(String[] stringArray) {
        try {
            Calendar calendar = Calendar.getInstance();
            Date[] dateArray = new Date[]{calendar.getTime()};
            int[] nArray = new int[]{calendar.get(11)};
            int[] nArray2 = new int[]{21};
            int[] nArray3 = new int[]{calendar.get(6), calendar.get(7)};
            long[] lArray = new long[]{System.currentTimeMillis(), System.currentTimeMillis() + 500000L};
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

